package cn.ibizlab.util.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Set;

public class EntityMP extends EntityBase {

    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private Set<String> focusNull;

    public Set<String> getFocusNull() {
        if(focusNull==null)
            focusNull=new HashSet<>();
        return focusNull;
    }

    public void setFocusNull(Set<String> focusNull) {
        this.focusNull = focusNull;
    }

    @Override
    public void modify(String field,Object val) {
        super.modify(field,val);
        if(val==null)
            this.getFocusNull().add(field.toLowerCase());
        else
            this.getFocusNull().remove(field.toLowerCase());
    }

    public UpdateWrapper getUpdateWrapper(boolean clean) {
        UpdateWrapper wrapper=new UpdateWrapper();
        for(String nullField:getFocusNull()) {
            wrapper.set(nullField,null);
        }
        if(clean)
            focusNull.clear();
        return  wrapper;
    }

}
