package cn.ibizlab.util.annotation;

import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEPredefinedFieldFillMode;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.FIELD})
public @interface DEPredefinedField
{
	/**
	 * 填充模式
	 * @return
	 */
	DEPredefinedFieldFillMode fill() default DEPredefinedFieldFillMode.INSERT_UPDATE;

	/**
	 * 预置属性类型
	 * @return
	 */
	DEPredefinedFieldType preType() default DEPredefinedFieldType.DEFAULT;

	/**
	 * 有效逻辑值
	 */
	String validLogicValue() default "";
}

