package cn.ibizlab.util.web;

import lombok.extern.slf4j.Slf4j;
import cn.ibizlab.util.service.MybatisSearchContext;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;

@Slf4j
public class SearchContextHandlerMethodArgumentResolver implements HandlerMethodArgumentResolver {

	@Override
	public boolean supportsParameter(MethodParameter parameter) {
		return MybatisSearchContext.class.isAssignableFrom(parameter.getParameterType());
	}

	@Override
	public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer,
			NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
		MybatisSearchContext searchContext = (MybatisSearchContext)parameter.getParameterType().newInstance();
		Map<String, String[]> searchParamList = webRequest.getParameterMap();
		PageableHandlerMethodArgumentResolver pageableResolver = new PageableHandlerMethodArgumentResolver();
		Pageable pageable = pageableResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory) ;
		searchContext.setPageable(pageable);

		for (String searchParam : searchParamList.keySet()) {
			if(searchParam.equalsIgnoreCase("page")||searchParam.equalsIgnoreCase("size")||searchParam.equalsIgnoreCase("sort"))
				continue ;
			if(searchParam.equalsIgnoreCase("query")){
				searchContext.setQuery(searchParamList.get(searchParam)[0]);
				continue ;
			}
			if(searchParam.equalsIgnoreCase("customparams")){
				searchContext.setCustomParams(searchParamList.get(searchParam)[0]);
				continue ;
			}
			if(searchParam.equalsIgnoreCase("customcond")){
				searchContext.setCustomCond(searchParamList.get(searchParam)[0]);
				continue ;
			}

			boolean userParam=true;
			PropertyDescriptor searchField = new PropertyDescriptor(searchParam, searchContext.getClass());
			if(!ObjectUtils.isEmpty(searchField)){
				Method fieldSetMethod = searchField.getWriteMethod();
				if(!ObjectUtils.isEmpty(fieldSetMethod)){
					//对字段值进行类型转换
					Object deFieldDefaultValueObj=fieldValueConvert(searchParamList.get(searchParam)[0],searchField);
					fieldSetMethod.invoke(searchContext,deFieldDefaultValueObj);
					userParam=false;
				}
			}

			if(userParam){
				searchContext.set(searchParam, searchParamList.get(searchParam)[0]);
			}

		}
		return searchContext;
	}

	/**
	 * 值类型转换
	 * @param fieldValue
	 * @param field
	 */
	private Object fieldValueConvert(String fieldValue,PropertyDescriptor field){

		Object resultValue=fieldValue;

		String targetType=field.getPropertyType().getSimpleName();

		if(targetType.equals("Boolean")){
			resultValue=Boolean.valueOf(fieldValue);
		}
		else if(targetType.equals("Character")){
			resultValue=fieldValue.toCharArray();
		}
		else if(targetType.equals("Byte")){
			resultValue=Byte.valueOf(fieldValue);
		}
		else if(targetType.equals("Short")){
			resultValue=Short.valueOf(fieldValue);
		}
		else if(targetType.equals("Integer")){
			resultValue= Integer.valueOf(fieldValue);
		}
		else if(targetType.equals("Long")){
			resultValue=Long.valueOf(fieldValue);
		}
		else if(targetType.equals("Float")){
			resultValue= Float.valueOf(fieldValue);
		}
		else if(targetType.equals("Double")){
			resultValue= Double.valueOf(fieldValue);
		}
		return resultValue;
	}
}
