package cn.ibizlab;

import java.util.List;

import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.databind.ObjectMapper;

import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import cn.ibizlab.util.serialize.DomainSerializerProvider;
import cn.ibizlab.util.helper.UniqueNameGenerator;
import cn.ibizlab.util.web.SearchContextHandlerMethodArgumentResolver;

@Slf4j
@SpringBootApplication(exclude = {

})
@Import({
//    cn.ibizlab
})
@EnableDiscoveryClient
@Configuration
@EnableTransactionManagement
public class IbzdictApplication extends WebMvcConfigurerAdapter {

    public static void main(String[] args) {
        SpringApplicationBuilder builder=new SpringApplicationBuilder(IbzdictApplication.class);
        builder.run(args);
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        super.addArgumentResolvers(argumentResolvers);
        argumentResolvers.add(new SearchContextHandlerMethodArgumentResolver());
    }
}
