/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'dictitemval',
          prop: 'itemval',
          dataType: 'TEXT',
        },
        {
          name: 'dictid',
          prop: 'dictid',
          dataType: 'PICKUP',
        },
        {
          name: 'showorder',
          prop: 'showorder',
          dataType: 'INT',
        },
        {
          name: 'pitemval',
          prop: 'pitemval',
          dataType: 'TEXT',
        },
        {
          name: 'updatedate',
          prop: 'updatedate',
          dataType: 'DATETIME',
        },
        {
          name: 'itemicon',
          prop: 'itemicon',
          dataType: 'TEXT',
        },
        {
          name: 'itemfilter',
          prop: 'itemfilter',
          dataType: 'TEXT',
        },
        {
          name: 'ibzdictitemname',
          prop: 'itemname',
          dataType: 'TEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'itemname',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'itemid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'itemid',
          dataType: 'GUID',
        },
        {
          name: 'itemcls',
          prop: 'itemcls',
          dataType: 'TEXT',
        },
        {
          name: 'ibzdict',
          prop: 'dictid',
          dataType: 'FONTKEY',
        },
        {
          name: 'ibzdictitem',
          prop: 'itemid',
        },
      {
        name: 'n_ibzdictitemname_like',
        prop: 'n_ibzdictitemname_like',
        dataType: 'TEXT',
      },
      {
        name: 'n_dictitemval_like',
        prop: 'n_dictitemval_like',
        dataType: 'TEXT',
      },
      {
        name: 'ibzdict',
        prop: 'dictid',
        dataType: 'FONTKEY',
      },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        }
      ]
    }
  }

}