package cn.ibizlab.util.annotation;

import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.FIELD})
public @interface DEField
{
	/**
	 * 是否为数据主键
	 * @return
	 */
	boolean isKeyField() default false;
	/**
	 * 默认值
	 * @return
	 */
	String defaultValue() default "";

	/**
	 * 默认值类型
	 * @return
	 */
	DEFieldDefaultValueType defaultValueType() default DEFieldDefaultValueType.NONE;

	/**
	 * 预置属性类型
	 * @return
	 */
	DEPredefinedFieldType preType() default DEPredefinedFieldType.DEFAULT;
}

