package cn.ibizlab.util.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

@Data
public class EntityBase implements Serializable {

    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)
    private Set<String> focusNull;

    @JsonIgnore
    @JSONField(serialize = false)
    public void addFocusNull(String field) {
        this.getFocusNull().add(field);
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public Set<String> getFocusNull() {
        if(focusNull==null)
            focusNull=new HashSet<>();
        return focusNull;
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public UpdateWrapper getUpdateWrapper(boolean clean) {
        UpdateWrapper wrapper=new UpdateWrapper();
        for(String nullField:getFocusNull()) {
            wrapper.set(nullField,null);
        }
        if(clean)
            focusNull.clear();
        return  wrapper;
    }



}

