package cn.ibizlab.core.data.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.data.domain.POModel;
import cn.ibizlab.core.data.filter.POModelSearchContext;


/**
 * 实体[POModel] 服务对象接口
 */
public interface IPOModelService {

    boolean create(POModel et);
    void createBatch(List<POModel> list);
    boolean update(POModel et);
    void updateBatch(List<POModel> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    POModel get(String key);
    POModel getDraft(POModel et);
    boolean checkKey(POModel et);
    boolean save(POModel et);
    void saveBatch(List<POModel> list);
    Page<POModel> searchDefault(POModelSearchContext context);

}



