package cn.ibizlab.core.data.lite;

import cn.ibizlab.util.helper.DataObject;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 实体[属性]
 */
@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@JsonIgnoreProperties(value = "handler")
@ApiModel("属性")
public class MetaFieldModel  {


    /**
     * 属性标识
     */
    @JSONField(name = "field_id")
    @JsonProperty("field_id")
    @ApiModelProperty("属性标识")
    private String fieldId;
    /**
     * 属性名称
     */
    @JSONField(name = "field_name")
    @JsonProperty("field_name")
    @ApiModelProperty("属性名称")
    private String fieldName;
    /**
     * 代码名称
     */
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    @ApiModelProperty("代码名称")
    private String codeName;
    /**
     * 实体标识
     */
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    @ApiModelProperty("实体标识")
    private String entityId;
    /**
     * 实体名称
     */
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    @ApiModelProperty("实体名称")
    private String entityName;
    /**
     * 实体代码名称
     */
    @JSONField(name = "entity_code_name")
    @JsonProperty("entity_code_name")
    @ApiModelProperty("实体代码名称")
    private String entityCodeName;
    /**
     * 系统
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @ApiModelProperty("系统")
    private String systemId;
    /**
     * 属性逻辑名
     */
    @JSONField(name = "field_logic_name")
    @JsonProperty("field_logic_name")
    @ApiModelProperty("属性逻辑名")
    private String fieldLogicName;
    /**
     * 属性全路径名称
     */
    @JSONField(name = "field_uni_name")
    @JsonProperty("field_uni_name")
    @ApiModelProperty("属性全路径名称")
    private String fieldUniName;
    /**
     * 显示名称
     */
    @JSONField(name = "field_show_name")
    @JsonProperty("field_show_name")
    @ApiModelProperty("显示名称")
    private String fieldShowName;
    /**
     * 引用属性标识
     */
    @JSONField(name = "ref_field_id")
    @JsonProperty("ref_field_id")
    @ApiModelProperty("引用属性标识")
    private String refFieldId;
    /**
     * 引用属性名称
     */
    @JSONField(name = "ref_field_name")
    @JsonProperty("ref_field_name")
    @ApiModelProperty("引用属性名称")
    private String refFieldName;
    /**
     * 引用属性代码名称
     */
    @JSONField(name = "ref_field_code_name")
    @JsonProperty("ref_field_code_name")
    @ApiModelProperty("引用属性代码名称")
    private String refFieldCodeName;
    /**
     * 引用关系标识
     */
    @JSONField(name = "relation_id")
    @JsonProperty("relation_id")
    @ApiModelProperty("引用关系标识")
    private String relationId;
    /**
     * 引用关系
     */
    @JSONField(name = "relation_name")
    @JsonProperty("relation_name")
    @ApiModelProperty("引用关系")
    private String relationName;
    /**
     * 关系代码
     */
    @JSONField(name = "relation_code_name")
    @JsonProperty("relation_code_name")
    @ApiModelProperty("关系代码")
    private String relationCodeName;
    /**
     * 引用实体
     */
    @JSONField(name = "ref_entity_name")
    @JsonProperty("ref_entity_name")
    @ApiModelProperty("引用实体")
    private String refEntityName;
    /**
     * 主键
     */
    @JSONField(name = "key_field")
    @JsonProperty("key_field")
    @ApiModelProperty("主键")
    private Integer keyField;
    /**
     * 主信息
     */
    @JSONField(name = "major_field")
    @JsonProperty("major_field")
    @ApiModelProperty("主信息")
    private Integer majorField;
    /**
     * 联合主键
     */
    @JSONField(name = "union_key")
    @JsonProperty("union_key")
    @ApiModelProperty("联合主键")
    private String unionKey;
    /**
     * 属性类型
     */
    @JSONField(name = "field_type")
    @JsonProperty("field_type")
    @ApiModelProperty("属性类型")
    private String fieldType;
    /**
     * 预定义类型
     */
    @JSONField(name = "predefined")
    @JsonProperty("predefined")
    @ApiModelProperty("预定义类型")
    private String predefined;
    /**
     * 数据字典
     */
    @JSONField(name = "dict")
    @JsonProperty("dict")
    @ApiModelProperty("数据字典")
    private String dict;
    /**
     * 允许为空
     */
    @JSONField(name = "nullable")
    @JsonProperty("nullable")
    @ApiModelProperty("允许为空")
    private Integer nullable;
    /**
     * 物理属性
     */
    @JSONField(name = "physical_field")
    @JsonProperty("physical_field")
    @ApiModelProperty("物理属性")
    private Integer physicalField;
    /**
     * 数据类型
     */
    @JSONField(name = "data_type")
    @JsonProperty("data_type")
    @ApiModelProperty("数据类型")
    private String dataType;
    /**
     * 长度
     */
    @JSONField(name = "data_length")
    @JsonProperty("data_length")
    @ApiModelProperty("长度")
    private Integer dataLength;
    /**
     * 精度
     */
    @JSONField(name = "data_preci")
    @JsonProperty("data_preci")
    @ApiModelProperty("精度")
    private Integer dataPreci;
    /**
     * 逻辑表达式
     */
    @JSONField(name = "expression")
    @JsonProperty("expression")
    @ApiModelProperty("逻辑表达式")
    private String expression;
    /**
     * 扩展属性
     */
    @JSONField(name = "extension_field")
    @JsonProperty("extension_field")
    @ApiModelProperty("扩展属性")
    private Integer extensionField;
    /**
     * 审计
     */
    @JSONField(name = "is_enable_audit")
    @JsonProperty("is_enable_audit")
    @ApiModelProperty("审计")
    private Integer isEnableAudit;
    /**
     * 排序
     */
    @JSONField(name = "show_order")
    @JsonProperty("show_order")
    @ApiModelProperty("排序")
    private Integer showOrder;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("创建时间")
    private Timestamp createdate;
    /**
     * 最后修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("最后修改时间")
    private Timestamp updatedate;


    /**
     * 扩展参数
     */
    @JSONField(name = "ext_params")
    @JsonProperty("ext_params")
    private String extParams;

    @JSONField(serialize = false)
    @JsonIgnore
    private Map<String,Object> extensionparams;

    public Object get(String key)
    {
        if(extensionparams==null)
            extensionparams=Setting.getMap(extParams);
        return extensionparams.get(key);
    }

    public MetaFieldModel set(String key,Object value)
    {
        if(value==null)
            return this;
        if(extensionparams==null)
            extensionparams=Setting.getMap(extParams);

        extensionparams.put(key,value);
        List<Setting> settingList=new ArrayList<>();
        for(Map.Entry<String,Object> entry:extensionparams.entrySet()) {
            if(!entry.getKey().equalsIgnoreCase("param"))
                settingList.add(new Setting().setProperty(entry.getKey()).setValue(DataObject.getStringValue(entry.getValue(), "")));
        }
        return setExtParams(JSON.toJSONString(settingList));
    }


}


