package cn.ibizlab.config;


import java.util.HashMap;
import java.util.Map;
 
import javax.servlet.http.HttpServletRequest;
 
import org.springframework.cloud.netflix.zuul.filters.support.FilterConstants;
import org.springframework.stereotype.Component;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
 
 
 
 
 
@Component
public class DevUrlRedirectFilter extends ZuulFilter  {
 
	

    @Override
    public Object run() {
    	RequestContext ctx = RequestContext.getCurrentContext();
		HttpServletRequest request = ctx.getRequest();
		String url = request.getRequestURI();
		if(url.startsWith("/ibiz-repo"))
		{
			String[] split = url.split("/");
			if (split.length>2) {
				url=url.replaceFirst("/"+split[1]+"/"+split[2]+"/", "/");
				ctx.put(FilterConstants.REQUEST_URI_KEY, url);
			}
		}

    	return null;
    }
    
	@Override
	public boolean shouldFilter() {
		return true;
	}

	@Override
	public int filterOrder() {
		return 1;
	}

	@Override
	public String filterType() {
		return FilterConstants.ROUTE_TYPE;
	}
 
}