package cn.ibizlab.core.data.service.impl;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Collection;

import cn.ibizlab.core.data.domain.DOModel;
import cn.ibizlab.core.data.model.PojoSchema;
import cn.ibizlab.core.data.service.ModelService;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import cn.ibizlab.core.data.domain.DTOModel;
import cn.ibizlab.core.data.filter.DTOModelSearchContext;
import cn.ibizlab.core.data.service.IDTOModelService;


/**
 * 实体[数据传输对象] 无存储服务对象接口实现
 */
@Slf4j
@Service
public class DTOModelServiceImpl implements IDTOModelService {

    @Autowired
    private ModelService modelService;

    @Override
    public boolean create(DTOModel et) {
        //代码实现
        return true;
    }

    public void createBatch(List<DTOModel> list){
    }

    @Override
    public boolean update(DTOModel et) {
        //代码实现
        return true;
    }

    public void updateBatch(List<DTOModel> list){
    }

    @Override
    public boolean remove(String key) {
        return true;
    }

    public void removeBatch(Collection<String> idList){
    }

    @Override
    public DTOModel get(String key) {
        DTOModel dtoModel=new DTOModel();
        PojoSchema schema= null;
        String[] args=key.split("[.]");
        String system=args[0];
        String dto=args[2];

        String entity=dto;
        if(entity.endsWith("DTO"))
            entity=entity.substring(0,entity.length()-3);



        Path storePath = Paths.get(ModelService.MODEL_PATH,system,"repo",entity,"dto",dto+".json");

        if(!Files.exists(storePath))
        {
            DOModel doModel = modelService.getDOModel(system,entity);
            schema = doModel.getSchema().copy();
            system=doModel.getSystemId();
            dto=dto.replace(entity,doModel.getName());
            entity=doModel.getName();
            key=system.concat(".dto.").concat(dto);
            storePath = Paths.get(ModelService.MODEL_PATH,system,"repo",entity,"dto",dto+".json");
        }

        if(!Files.exists(storePath))
        {
            if(schema!=null) {
                schema.setName(dto);
                schema.setId(key);
                if(schema!=null)
                    schema.writeTo(storePath);
            }
        }
        else
            schema=PojoSchema.fromPath(storePath);

        if(schema!=null)
            dtoModel.setSchema(schema);
        else
            throw new BadRequestAlertException("未找到对应的模型","DTOModel",key);


        return dtoModel;
    }

    @Override
    public DTOModel getDraft(DTOModel et) {
        return et;
    }

    @Override
    public boolean checkKey(DTOModel et) {
        return false;
    }
    @Override
    @Transactional
    public boolean save(DTOModel et) {
        //代码实现
        return true;
    }

    @Override
    public void saveBatch(List<DTOModel> list) {
    }





    /**
     * 查询集合 数据集
     */
    @Override
    public Page<DTOModel> searchDefault(DTOModelSearchContext context) {
        return new PageImpl<DTOModel>(new ArrayList(),context.getPageable(),0);
    }

}


