package cn.ibizlab.core.data.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.data.domain.DOModel;
import cn.ibizlab.core.data.filter.DOModelSearchContext;


/**
 * 实体[DOModel] 服务对象接口
 */
public interface IDOModelService {

    boolean create(DOModel et);
    void createBatch(List<DOModel> list);
    boolean update(DOModel et);
    void updateBatch(List<DOModel> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    DOModel get(String key);
    DOModel getDraft(DOModel et);
    boolean checkKey(DOModel et);
    boolean save(DOModel et);
    void saveBatch(List<DOModel> list);
    Page<DOModel> searchDefault(DOModelSearchContext context);

}



