package cn.ibizlab.core.data.lite;

import cn.ibizlab.util.helper.DataObject;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 实体[实体]
 */
@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@JsonIgnoreProperties(value = "handler")
public class MetaEntityModel{

    /**
     * 标识
     */
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    private String entityId;
    /**
     * 实体名
     */
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    private String entityName;
    /**
     * 逻辑名称
     */
    @JSONField(name = "logic_name")
    @JsonProperty("logic_name")
    private String logicName;
    /**
     * 代码名称
     */
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    private String codeName;
    /**
     * 表名称
     */
    @JSONField(name = "table_name")
    @JsonProperty("table_name")
    private String tableName;
    /**
     * 系统标识
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    private String systemId;
    /**
     * 系统
     */
    @JSONField(name = "system_name")
    @JsonProperty("system_name")
    private String systemName;
    /**
     * 数据源标识
     */
    @JSONField(name = "ds_id")
    @JsonProperty("ds_id")
    private String dsId;
    /**
     * 数据源
     */
    @JSONField(name = "ds_name")
    @JsonProperty("ds_name")
    private String dsName;

    /**
     * 模块标识
     */
    @JSONField(name = "module_id")
    @JsonProperty("module_id")
    private String moduleId;
    /**
     * 模块
     */
    @JSONField(name = "module_name")
    @JsonProperty("module_name")
    private String moduleName;
    /**
     * 扩展参数
     */
    @JSONField(name = "ext_params")
    @JsonProperty("ext_params")
    private String extParams;
    /**
     * 排序
     */
    @JSONField(name = "show_order")
    @JsonProperty("show_order")
    private Integer showOrder;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;
    /**
     * 最后修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;


    @JSONField(serialize = false)
    @JsonIgnore
    private Map<String,Object> extensionparams;

    public Object get(String key)
    {
        if(extensionparams==null)
            extensionparams=Setting.getMap(extParams);
        return extensionparams.get(key);
    }

    public MetaEntityModel set(String key,Object value)
    {
        if(value==null)
            return this;
        if(extensionparams==null)
            extensionparams=Setting.getMap(extParams);

        extensionparams.put(key,value);
        List<Setting> settingList=new ArrayList<>();
        for(Map.Entry<String,Object> entry:extensionparams.entrySet()) {
            if(!entry.getKey().equalsIgnoreCase("param"))
                settingList.add(new Setting().setProperty(entry.getKey()).setValue(DataObject.getStringValue(entry.getValue(), "")));
        }
        return setExtParams(JSON.toJSONString(settingList));
    }

}


