package cn.ibizlab.core.data.rest;

import cn.ibizlab.core.data.dto.BaseData;
import cn.ibizlab.core.data.dto.FilterData;
import cn.ibizlab.core.data.dto.RequestData;
import cn.ibizlab.core.data.dto.ResponseData;
import cn.ibizlab.core.data.service.IDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@Api(tags = {"数据" })
@RestController("api-data")
@RequestMapping("")
public class DataResource
{
    @Autowired
    public IDataService dataService;

	@ApiOperation(value = "保存数据", tags = {"数据" },  notes = "保存数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/ibiz-repository/{system}/{scope}/{entity}/{method}","/ibiz-repo/{system}/{entity}/{method}"})
	public ResponseEntity call(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,
			@PathVariable(name = "method",required = true) String method,
			@RequestBody RequestData requestData) {
		ResponseData responseData=dataService.call(system,scope,entity,datasource,method,requestData);
		return ResponseEntity.status(HttpStatus.OK).body(responseData.getBody());
	}



    @ApiOperation(value = "新建数据", tags = {"数据" },  notes = "新建数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/ibiz-repository/{system}/{scope}/{entity}","/ibiz-repo/{system}/{entity}",
			"/ibiz-repository/{system}/{scope}/{entity}/create","/ibiz-repo/{system}/{entity}/create"})
    public ResponseEntity<BaseData> create(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @Validated @RequestBody BaseData baseData) {
		dataService.create(system,scope,entity,datasource,baseData);
		return ResponseEntity.status(HttpStatus.OK).body(baseData);
    }

    @ApiOperation(value = "批量新建数据", tags = {"数据" },  notes = "批量新建数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/ibiz-repository/{system}/{scope}/{entity}/batch","/ibiz-repo/{system}/{entity}/batch",
			"/ibiz-repository/{system}/{scope}/{entity}/createbatch","/ibiz-repo/{system}/{entity}/createbatch"})
    public ResponseEntity<Boolean> createBatch(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @RequestBody List<BaseData> baseDatas) {
        dataService.createBatch(system,scope,entity,datasource,baseDatas);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "获取数据", tags = {"数据" },  notes = "获取数据")
	@RequestMapping(method = RequestMethod.GET, value = {"/ibiz-repository/{system}/{scope}/{entity}/{key}","/ibiz-repo/{system}/{entity}/{key}"})
    public ResponseEntity<BaseData> get(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @PathVariable(name = "key",required = true) String key) {
        return ResponseEntity.status(HttpStatus.OK).body(dataService.get(system,scope,entity,datasource,key));
    }

	@ApiOperation(value = "获取数据", tags = {"数据" },  notes = "获取数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/ibiz-repository/{system}/{scope}/{entity}/get","/ibiz-repo/{system}/{entity}/get"})
	public ResponseEntity<BaseData> get(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @Validated @RequestBody BaseData baseData) {
		return ResponseEntity.status(HttpStatus.OK).body(dataService.getByMap(system,scope,entity,datasource,baseData));
	}

    @ApiOperation(value = "删除数据", tags = {"数据" },  notes = "删除数据")
	@RequestMapping(method = RequestMethod.DELETE, value = {"/ibiz-repository/{system}/{scope}/{entity}/{key}","/ibiz-repo/{system}/{entity}/{key}"})
    public ResponseEntity<Boolean> remove(@PathVariable(name = "system",required = true) String system,@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,@RequestParam(name = "datasource",required = false) String datasource, @PathVariable(name = "key",required = true) String key) {
         return ResponseEntity.status(HttpStatus.OK).body(dataService.remove(system,scope,entity,datasource,key));
    }

	@ApiOperation(value = "删除数据", tags = {"数据" },  notes = "删除数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/ibiz-repository/{system}/{scope}/{entity}/remove","/ibiz-repo/{system}/{entity}/remove"})
	public ResponseEntity<Boolean> remove(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @Validated @RequestBody BaseData baseData) {
		return ResponseEntity.status(HttpStatus.OK).body(dataService.removeByMap(system,scope,entity,datasource,baseData));
	}

    @ApiOperation(value = "批量删除数据", tags = {"数据" },  notes = "批量删除数据")
	@RequestMapping(method = RequestMethod.DELETE, value = {"/ibiz-repository/{system}/{scope}/{entity}/batch","/ibiz-repo/{system}/{entity}/batch"})
    public ResponseEntity<Boolean> removeBatch(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @RequestBody List ids) {
        dataService.removeBatch(system,scope,entity,datasource,ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "批量删除数据", tags = {"数据" },  notes = "批量删除数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/ibiz-repository/{system}/{scope}/{entity}/removebatch","/ibiz-repo/{system}/{entity}/removebatch"})
	public ResponseEntity<Boolean> removeBatch2(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @RequestBody List ids) {
		dataService.removeBatch(system,scope,entity,datasource,ids);
		return  ResponseEntity.status(HttpStatus.OK).body(true);
	}

    @ApiOperation(value = "更新数据", tags = {"数据" },  notes = "更新数据")
	@RequestMapping(method = RequestMethod.PUT, value = {"/ibiz-repository/{system}/{scope}/{entity}/{key}","/ibiz-repo/{system}/{entity}/{key}",
			"/ibiz-repository/{system}/{scope}/{entity}","/ibiz-repo/{system}/{entity}"})
    public ResponseEntity<BaseData> update(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,
			@PathVariable(name = "key",required = false) String key, @RequestBody BaseData baseData) {
		dataService.update(system,scope,entity,datasource,baseData.setKey(key));
        return ResponseEntity.status(HttpStatus.OK).body(baseData);
    }

	@ApiOperation(value = "更新数据", tags = {"数据" },  notes = "更新数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/ibiz-repository/{system}/{scope}/{entity}/update","/ibiz-repo/{system}/{entity}/update"})
	public ResponseEntity<BaseData> update(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @RequestBody BaseData baseData) {
		dataService.update(system,scope,entity,datasource,baseData);
		return ResponseEntity.status(HttpStatus.OK).body(baseData);
	}

    @ApiOperation(value = "批量更新数据", tags = {"数据" },  notes = "批量更新数据")
	@RequestMapping(method = RequestMethod.PUT, value = {"/ibiz-repository/{system}/{scope}/{entity}/batch","/ibiz-repo/{system}/{entity}/batch"})
    public ResponseEntity<Boolean> updateBatch(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @RequestBody List<BaseData> baseDatas) {
        dataService.updateBatch(system,scope,entity,datasource,baseDatas);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "批量更新数据", tags = {"数据" },  notes = "批量更新数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/ibiz-repository/{system}/{scope}/{entity}/updatebatch","/ibiz-repo/{system}/{entity}/updatebatch"})
	public ResponseEntity<Boolean> updateBatch2(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @RequestBody List<BaseData> baseDatas) {
		dataService.updateBatch(system,scope,entity,datasource,baseDatas);
		return  ResponseEntity.status(HttpStatus.OK).body(true);
	}

    @ApiOperation(value = "检查数据", tags = {"数据" },  notes = "检查数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/ibiz-repository/{system}/{scope}/{entity}/checkkey","/ibiz-repo/{system}/{entity}/checkkey"})
    public ResponseEntity<Boolean> checkKey(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @RequestBody BaseData baseData) {
        return  ResponseEntity.status(HttpStatus.OK).body(dataService.checkKey(system,scope,entity,datasource,baseData));
    }

    @ApiOperation(value = "获取数据草稿", tags = {"数据" },  notes = "获取数据草稿")
	@RequestMapping(method = {RequestMethod.GET,RequestMethod.POST}, value = {"/ibiz-repository/{system}/{scope}/{entity}/getdraft","/ibiz-repo/{system}/{entity}/getdraft"})
    public ResponseEntity<BaseData> getDraft(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,  @RequestBody(required = false) BaseData baseData) {
		dataService.getDraft(system,scope,entity,datasource,baseData);
        return ResponseEntity.status(HttpStatus.OK).body(baseData);
    }

    @ApiOperation(value = "保存数据", tags = {"数据" },  notes = "保存数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/ibiz-repository/{system}/{scope}/{entity}/save","/ibiz-repo/{system}/{entity}/save"})
    public ResponseEntity<BaseData> save(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,@RequestBody BaseData baseData) {
        dataService.save(system,scope,entity,datasource,baseData);
        return ResponseEntity.status(HttpStatus.OK).body(baseData);
    }

    @ApiOperation(value = "批量保存数据", tags = {"数据" },  notes = "批量保存数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/ibiz-repository/{system}/{scope}/{entity}/savebatch","/ibiz-repo/{system}/{entity}/savebatch"})
    public ResponseEntity<Boolean> saveBatch(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,@RequestBody List<BaseData> baseDatas) {
        dataService.saveBatch(system,scope,entity,datasource,baseDatas);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "获取数据集", tags = {"数据" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value={"/ibiz-repository/{system}/{scope}/{entity}/fetch{dataset}","/ibiz-repo/{system}/{entity}/fetch{dataset}"})
	public ResponseEntity<List<BaseData>> fetch(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@PathVariable(name = "dataset",required = true) String dataset,
			FilterData context) {
        Page<BaseData> baseDatas = dataService.fetch(system,scope,entity,context.getDataSource(),dataset,context,context.getPageable()) ;
        List<BaseData> list = baseDatas.getContent();
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(baseDatas.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "获取数据集", tags = {"数据" } ,notes = "获取数据集")
	@RequestMapping(method= RequestMethod.POST , value={"/ibiz-repository/{system}/{scope}/{entity}/fetch{dataset}","/ibiz-repo/{system}/{entity}/fetch{dataset}"})
	public ResponseEntity<List<BaseData>> fetch2(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,@PathVariable(name = "dataset",required = true) String dataset,
			@RequestBody FilterData context) {
		Page<BaseData> baseDatas = dataService.fetch(system,scope,entity,datasource,dataset,context,context.getPageable()) ;
		List<BaseData> list = baseDatas.getContent();
		return ResponseEntity.status(HttpStatus.OK)
				.header("x-page", String.valueOf(context.getPageable().getPageNumber()))
				.header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
				.header("x-total", String.valueOf(baseDatas.getTotalElements()))
				.body(list);
	}

	@ApiOperation(value = "查询数据集", tags = {"数据" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value={"/ibiz-repository/{system}/{scope}/{entity}/search{dataset}","/ibiz-repo/{system}/{entity}/search{dataset}"})
	public ResponseEntity<Page<BaseData>> search(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,@PathVariable(name = "dataset",required = true) String dataset,
			@RequestBody FilterData context) {
		Page<BaseData> baseDatas = dataService.fetch(system,scope,entity,datasource,dataset,context,context.getPageable()) ;
		return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(baseDatas.getContent(), context.getPageable(), baseDatas.getTotalElements()));
	}



}

