package cn.ibizlab.core.data.lite;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import javax.annotation.PostConstruct;
import java.io.File;

@Component("DataLiteStorage")
public class LiteStorage {

    public static String MODEL_PATH;

    private static LiteModelFeignClient liteModelFeignClient;
    private static DynamicModelService dynamicModelService;



    public static void setDynamicModelService(DynamicModelService service)
    {
        if(LiteStorage.dynamicModelService==null)
            LiteStorage.dynamicModelService=service;
    }

    public static DynamicModelService getDynamicModelService()
    {
        return dynamicModelService;
    }

    public static void setLiteModelService(LiteModelFeignClient service)
    {
        if(LiteStorage.liteModelFeignClient==null)
            LiteStorage.liteModelFeignClient=service;
    }

    public static LiteModelFeignClient getLiteModelService()
    {
        return liteModelFeignClient;
    }


    public static EntityModel getEntityModel(String system,String entity)
    {

        EntityModel entityModel = null;

        try {
            entityModel = getDynamicModelService().getDynamicEntity(system,entity);
        } catch (Exception exception) {

        }
        if(entityModel==null)
            entityModel = getLiteModelService().getProxyEntityModel(system,entity);

        return entityModel;
    }


    @Autowired
    private LiteModelFeignClient liteService;

    @Autowired
    @Lazy
    private DynamicModelService dynamicService;


    @Value("${ibiz.model.path:/app/file/model/}")
    private  String modelPath;

    public String getModelPath()
    {
        if(modelPath.equals(File.separator))
            return modelPath.substring(0,modelPath.length()-1);
        return modelPath;
    }

    @PostConstruct
    public void init(){
        LiteStorage.setLiteModelService(liteService);
        LiteStorage.setDynamicModelService(dynamicService);
        LiteStorage.MODEL_PATH=getModelPath();
    }


}
