package cn.ibizlab.core.data.lite;

import org.springframework.cache.annotation.Cacheable;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 实体[MetaModel] 服务对象接口
 */
@FeignClient(value = "${ibiz.ref.service.ibzlite-api:ibzlite-api}", contextId = "DataLiteModel", fallback = LiteModelFallback.class)
public interface LiteModelFeignClient {


    String defaultToken="Bearer eyJhbGciOiJSUzI1NiJ9.eyJzdWIiOiJpYnphZG1pbiIsImV4cCI6MTkzMzI0MTkzNywiaWF0IjoxNjE3ODgxOTM3fQ.dFmy-Sx0SlKQcDhbbAs9_bPkbAfy8eRLlGdtl-YZhfU82bCuS4n56ESK8fE0xQqqNJJM87X7U9CnWxRk9z9Xh_dqch-GW8qPj5s25cFsR96V2Ke-6XirCnS-fTRfY9ZIcqVT2gvFUE1MiSbEC-7SPgxcGrNZv0bLzmlW3drlSyQ";


    @GetMapping( "/lite/{system}/entities/{entity}")
    @Cacheable( value="entitymodel",key = "'row:'+#p0+'.'+#p1")
    EntityModel getProxyEntityModel(@PathVariable("system") String system, @PathVariable("entity") String entity);

    @GetMapping("/lite/{system}/entities")
    List<MetaEntityModel> getEntityModel(@PathVariable("system") String system);

    @GetMapping( "/lite/sysapps")
    @Cacheable( value="syspssystem",key = "'row:sys-dst-sys-apps'")
    List<DstSystemModel> getSysApps();


}
