package cn.ibizlab.core.data.service;

import java.util.List;
import java.util.Collection;

import cn.ibizlab.core.data.model.DSLink;
import org.springframework.data.domain.Page;

import cn.ibizlab.core.data.domain.DSSetting;
import cn.ibizlab.core.data.filter.DSSettingSearchContext;


/**
 * 实体[DSSetting] 服务对象接口
 */
public interface IDSSettingService {

    boolean create(DSSetting et);
    void createBatch(List<DSSetting> list);
    boolean update(DSSetting et);
    void updateBatch(List<DSSetting> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    DSSetting get(String key);
    DSSetting getDraft(DSSetting et);
    boolean checkKey(DSSetting et);
    boolean save(DSSetting et);
    void saveBatch(List<DSSetting> list);
    Page<DSSetting> searchDefault(DSSettingSearchContext context);
    DSLink getDataSource(String tag);
}



