package cn.ibizlab.core.data.dto;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RequestData<T> extends BaseData
{
	public RequestData set(String key, Object value)
	{
		this.put(key,value);
		return this;
	}



	public RequestData setKey(Object key)
	{
		super.setKey(key);
		return this;
	}


	private String system;
	private String scope;
	private String entity;
	private String method;
	private String dataSource;


	public String getSystem() {
		return system;
	}

	public RequestData setSystem(String system) {
		this.system = system;
		return this;
	}

	public String getScope() {
		return scope;
	}

	public RequestData setScope(String scope) {
		this.scope = scope;
		return this;
	}

	public String getEntity() {
		return entity;
	}

	public RequestData setEntity(String entity) {
		this.entity = entity;
		return this;
	}

	public String getMethod() {
		return method;
	}

	public RequestData setMethod(String method) {
		this.method = method;
		return this;
	}

	public String getDataSource() {
		return dataSource;
	}

	public RequestData setDataSource(String dataSource) {
		this.dataSource = dataSource;
		return this;
	}

	public RequestData setBody(T data)
	{
		return this.set("data",data);
	}

	public T getBody()
	{
		if(this.get("data")!=null)
			return (T)this.get("data");
		else
			return null;
	}

	public BaseData getBaseData()
	{
		Object body=getBody();
		if(body!=null&&body instanceof BaseData)
			return (BaseData)body;
		return this;
	}

	public List<BaseData> getListData()
	{
		Object body=getBody();
		if(body!=null&&body instanceof List)
		{
			if(((List) body).size()==0)
				return new ArrayList<>();
			else if(((List) body).get(0) instanceof BaseData)
				return (List<BaseData> )body;
			else
				return JSONArray.parseArray(JSON.toJSONString(body),BaseData.class);
		}
		return new ArrayList<>();
	}


}
