package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.data.domain.DOModel;
import cn.ibizlab.core.data.service.IDOModelService;
import cn.ibizlab.core.data.filter.DOModelSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"业务实体" })
@RestController("api-domodel")
@RequestMapping("")
public class DOModelResource {

    @Autowired
    public IDOModelService domodelService;

    @Autowired
    @Lazy
    public DOModelMapping domodelMapping;

    @ApiOperation(value = "新建业务实体", tags = {"业务实体" },  notes = "新建业务实体")
	@RequestMapping(method = RequestMethod.POST, value = "/domodels")
    public ResponseEntity<DOModelDTO> create(@Validated @RequestBody DOModelDTO domodeldto) {
        DOModel domain = domodelMapping.toDomain(domodeldto);
		domodelService.create(domain);
        DOModelDTO dto = domodelMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "批量新建业务实体", tags = {"业务实体" },  notes = "批量新建业务实体")
	@RequestMapping(method = RequestMethod.POST, value = "/domodels/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<DOModelDTO> domodeldtos) {
        domodelService.createBatch(domodelMapping.toDomain(domodeldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "获取业务实体", tags = {"业务实体" },  notes = "获取业务实体")
	@RequestMapping(method = RequestMethod.GET, value = "/domodels/{domodel_id}")
    public ResponseEntity<DOModelDTO> get(@PathVariable("domodel_id") String domodel_id) {
        DOModel domain = domodelService.get(domodel_id);
        DOModelDTO dto = domodelMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "删除业务实体", tags = {"业务实体" },  notes = "删除业务实体")
	@RequestMapping(method = RequestMethod.DELETE, value = "/domodels/{domodel_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("domodel_id") String domodel_id) {
         return ResponseEntity.status(HttpStatus.OK).body(domodelService.remove(domodel_id));
    }

    @ApiOperation(value = "批量删除业务实体", tags = {"业务实体" },  notes = "批量删除业务实体")
	@RequestMapping(method = RequestMethod.DELETE, value = "/domodels/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        domodelService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "更新业务实体", tags = {"业务实体" },  notes = "更新业务实体")
	@RequestMapping(method = RequestMethod.PUT, value = "/domodels/{domodel_id}")
    public ResponseEntity<DOModelDTO> update(@PathVariable("domodel_id") String domodel_id, @RequestBody DOModelDTO domodeldto) {
		DOModel domain  = domodelMapping.toDomain(domodeldto);
        domain .setId(domodel_id);
		domodelService.update(domain );
		DOModelDTO dto = domodelMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "批量更新业务实体", tags = {"业务实体" },  notes = "批量更新业务实体")
	@RequestMapping(method = RequestMethod.PUT, value = "/domodels/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<DOModelDTO> domodeldtos) {
        domodelService.updateBatch(domodelMapping.toDomain(domodeldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查业务实体", tags = {"业务实体" },  notes = "检查业务实体")
	@RequestMapping(method = RequestMethod.POST, value = "/domodels/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody DOModelDTO domodeldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(domodelService.checkKey(domodelMapping.toDomain(domodeldto)));
    }

    @ApiOperation(value = "获取业务实体草稿", tags = {"业务实体" },  notes = "获取业务实体草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/domodels/getdraft")
    public ResponseEntity<DOModelDTO> getDraft(DOModelDTO dto) {
        DOModel domain = domodelMapping.toDomain(dto);
        return ResponseEntity.status(HttpStatus.OK).body(domodelMapping.toDto(domodelService.getDraft(domain)));
    }

    @ApiOperation(value = "保存业务实体", tags = {"业务实体" },  notes = "保存业务实体")
	@RequestMapping(method = RequestMethod.POST, value = "/domodels/save")
    public ResponseEntity<DOModelDTO> save(@RequestBody DOModelDTO domodeldto) {
        DOModel domain = domodelMapping.toDomain(domodeldto);
        domodelService.save(domain);
        return ResponseEntity.status(HttpStatus.OK).body(domodelMapping.toDto(domain));
    }

    @ApiOperation(value = "批量保存业务实体", tags = {"业务实体" },  notes = "批量保存业务实体")
	@RequestMapping(method = RequestMethod.POST, value = "/domodels/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<DOModelDTO> domodeldtos) {
        domodelService.saveBatch(domodelMapping.toDomain(domodeldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "获取数据集", tags = {"业务实体" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/domodels/fetchdefault")
	public ResponseEntity<List<DOModelDTO>> fetchDefault(DOModelSearchContext context) {
        Page<DOModel> domains = domodelService.searchDefault(context) ;
        List<DOModelDTO> list = domodelMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "查询数据集", tags = {"业务实体" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/domodels/searchdefault")
	public ResponseEntity<Page<DOModelDTO>> searchDefault(@RequestBody DOModelSearchContext context) {
        Page<DOModel> domains = domodelService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domodelMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



}

