package cn.ibizlab.core.util.config;

import cn.ibizlab.core.data.elasticsearch.DynamicEsContextHolder;
import cn.ibizlab.core.data.elasticsearch.DynamicEsTemplate;
import cn.ibizlab.core.data.mongodb.DynamicMongoContextHolder;
import cn.ibizlab.core.data.mongodb.DynamicMongoTemplate;
import cn.ibizlab.util.helper.JSR310DateConverters;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.elasticsearch.client.reactive.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchTemplate;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Configuration
public class EsDBConfig {

    @Value("${spring.data.mongodb.uri:mongodb://localhost:27017/admin}")
    private  String uri;


    @Bean(name = "reactiveElasticsearchTemplate")
    @Lazy
    public ReactiveElasticsearchTemplate reactiveElasticsearchTemplate() {
        if(DynamicEsContextHolder.ES_CLIENT_DB_FACTORY_MAP.size()==0)
            DynamicEsContextHolder.addFactory("master",uri);
        Iterator<ReactiveElasticsearchClient> iterator = DynamicEsContextHolder.ES_CLIENT_DB_FACTORY_MAP.values().iterator();
        return new DynamicEsTemplate(iterator.next());
    }

    @Bean(name = "reactiveElasticsearchClient")
    @Lazy
    public ReactiveElasticsearchClient reactiveElasticsearchClient() {
        Iterator<ReactiveElasticsearchClient> iterator = DynamicEsContextHolder.ES_CLIENT_DB_FACTORY_MAP.values().iterator();
        return iterator.next();
    }

}