package cn.ibizlab.core.data.service;

import cn.ibizlab.core.data.domain.DOModel;
import cn.ibizlab.core.data.dto.BaseData;
import cn.ibizlab.core.data.dto.FilterData;
import cn.ibizlab.core.data.dto.RequestData;
import cn.ibizlab.core.data.dto.ResponseData;
import cn.ibizlab.core.data.model.DSLink;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;

public interface IDataService
{

    ResponseData call(DOModel model,String scope,DSLink dsLink,String method,RequestData requestData);

    BaseData create(DOModel model, String scope, DSLink dsLink, BaseData et);
    List<BaseData> createBatch(DOModel model,String scope,DSLink dsLink,List<BaseData> list);

    BaseData update(DOModel model,String scope,DSLink dsLink,BaseData et);
    List<BaseData> updateBatch(DOModel model,String scope,DSLink dsLink,List<BaseData> list);

    boolean remove(DOModel model,String scope,DSLink dsLink, Serializable key);
    boolean removeBatch(DOModel model,String scope,DSLink dsLink,List<Serializable> idList);
    boolean removeByMap(DOModel model,String scope,DSLink dsLink, BaseData et);
    boolean removeByMapBatch(DOModel model,String scope,DSLink dsLink,List<BaseData> list);

    BaseData get(DOModel model,String scope,DSLink dsLink,Serializable key);
    List<BaseData> getBatch(DOModel model,String scope,DSLink dsLink,List<Serializable> idList);
    BaseData getByMap(DOModel model,String scope,DSLink dsLink,BaseData et);
    List<BaseData> getByMapBatch(DOModel model,String scope,DSLink dsLink,List<BaseData> list);

    BaseData getDraft(DOModel model,String scope,DSLink dsLink,BaseData et);
    boolean checkKey(DOModel model,String scope,DSLink dsLink,BaseData et);

    BaseData save(DOModel model,String scope,DSLink dsLink,BaseData et);
    List<BaseData> saveBatch(DOModel model,String scope,DSLink dsLink,List<BaseData> list);

    List<BaseData> select(DOModel model,String scope,DSLink dsLink,BaseData et);
    Page<BaseData> select(DOModel model,String scope,DSLink dsLink,BaseData et,Pageable pageable);

    List<BaseData> query(DOModel model,String scope,DSLink dsLink,String dataQuery,FilterData context);
    Page<BaseData> query(DOModel model,String scope,DSLink dsLink,String dataQuery,FilterData context,Pageable pageable);

    List<BaseData> selectRaw(DOModel model,String scope,DSLink dsLink,String sql,FilterData context);
    boolean execRaw(DOModel model,String scope,DSLink dsLink,String sql,BaseData param);

    List<BaseData> fetch(DOModel model,String scope,DSLink dsLink,String dataSet,FilterData context);
    Page<BaseData> fetch(DOModel model,String scope,DSLink dsLink,String dataSet,FilterData context, Pageable pageable);



    default ResponseData call(RequestData requestData)
    {
        return call(requestData.getSystem(),requestData.getScope(),requestData.getEntity(),requestData.getDataSource(),requestData.getMethod(),requestData);
    }

    default ResponseData call(String system,String entity,String method,RequestData requestData)
    {
        return call(system,"",entity,method,"",requestData);
    }

    default BaseData create(String system,String entity,BaseData et)
    {
        return create(system,"",entity,"",et);
    }
    default List<BaseData> createBatch(String system,String entity,List<BaseData> list)
    {
        return createBatch(system,"",entity,"",list);
    }
    default BaseData update(String system,String entity,BaseData et)
    {
        return update(system,"",entity,"",et);
    }
    default List<BaseData> updateBatch(String system,String entity,List<BaseData> list)
    {
        return updateBatch(system,"",entity,"",list);
    }
    default boolean remove(String system,String entity,Serializable key)
    {
        return remove(system,"",entity,"",key);
    }
    default boolean removeBatch(String system,String entity,List<Serializable> idList)
    {
        return removeBatch(system,"",entity,"",idList);
    }
    default boolean removeByMap(String system,String entity,BaseData et)
    {
        return removeByMap(system,"",entity,"",et);
    }
    default boolean removeByMapBatch(String system,String entity,List<BaseData> list)
    {
        return removeByMapBatch(system,"",entity,"",list);
    }
    default BaseData get(String system,String entity,Serializable key)
    {
        return get(system,"",entity,"",key);
    }
    default List<BaseData> getBatch(String system,String entity,List<Serializable> idList)
    {
        return getBatch(system,"",entity,"",idList);
    }
    default BaseData getByMap(String system,String entity,BaseData et)
    {
        return getByMap(system,"",entity,"",et);
    }
    default List<BaseData> getByMapBatch(String system,String entity,List<BaseData> list)
    {
        return getByMapBatch(system,"",entity,"",list);
    }
    default BaseData getDraft(String system,String entity,BaseData et)
    {
        return getDraft(system,"",entity,"",et);
    }
    default boolean checkKey(String system,String entity,BaseData et)
    {
        return checkKey(system,"",entity,"",et);
    }
    default BaseData save(String system,String entity,BaseData et)
    {
        return save(system,"",entity,"",et);
    }
    default List<BaseData> saveBatch(String system,String entity,List<BaseData> list)
    {
        return saveBatch(system,"",entity,"",list);
    }
    default List<BaseData> select(String system,String entity,BaseData et){
        return select(system,"",entity,"",et);
    }
    default Page<BaseData> select(String system,String entity,BaseData et,Pageable pageable){
        return select(system,"",entity,"",et,pageable);
    }
    default List<BaseData> query(String system,String entity,String dataQuery,FilterData context){
        return query(system,"",entity,"",dataQuery,context);
    }
    default Page<BaseData> query(String system,String entity,String dataQuery,FilterData context,Pageable pageable){
        return query(system,"",entity,"",dataQuery,context,pageable);
    }
    default List<BaseData> selectRaw(String system,String entity,String sql,FilterData context){
        return selectRaw(system,"",entity,"",sql,context);
    }
    default boolean execRaw(String system,String entity,String sql,BaseData param){
        return execRaw(system,"",entity,"",sql,param);
    }
    default List<BaseData> fetch(String system,String entity, String dataSet,FilterData context)
    {
        return fetch(system,"",entity,"",dataSet,context);
    }
    default Page<BaseData> fetch(String system,String entity, String dataSet,FilterData context,Pageable pageable)
    {
        return fetch(system,"",entity,"",dataSet,context,pageable);
    }

    
    default ResponseData call(String system,String scope,String entity,String datasource,String method,RequestData requestData)
    {

        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        requestData.setSystem(model.getSystemId()).setScope(scope).setEntity(model.getName()).setMethod(method).setDataSource(datasource);
        return call(model,scope,dsLink,method,requestData);
    }
    default BaseData create(String system,String scope,String entity,String datasource,BaseData et)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return create(model,scope,dsLink,et);
    }
    default List<BaseData> createBatch(String system,String scope,String entity,String datasource,List<BaseData> list)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return createBatch(model,scope,dsLink,list);
    }
    default BaseData update(String system,String scope,String entity,String datasource,BaseData et)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return update(model,scope,dsLink,et);
    }
    default List<BaseData> updateBatch(String system,String scope,String entity,String datasource,List<BaseData> list)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return updateBatch(model,scope,dsLink,list);
    }
    default boolean remove(String system,String scope,String entity,String datasource,Serializable key)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return remove(model,scope,dsLink,key);
    }
    default boolean removeBatch(String system,String scope,String entity,String datasource,List<Serializable> idList)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return removeBatch(model,scope,dsLink,idList);
    }
    default boolean removeByMap(String system,String scope,String entity,String datasource,BaseData et)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return removeByMap(model,scope,dsLink,et);
    }
    default boolean removeByMapBatch(String system,String scope,String entity,String datasource,List<BaseData> list)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return removeByMapBatch(model,scope,dsLink,list);
    }
    default BaseData get(String system,String scope,String entity,String datasource,Serializable key)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return get(model,scope,dsLink,key);
    }
    default List<BaseData> getBatch(String system,String scope,String entity,String datasource,List<Serializable> idList)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return getBatch(model,scope,dsLink,idList);
    }
    default BaseData getByMap(String system,String scope,String entity,String datasource,BaseData et)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return getByMap(model,scope,dsLink,et);
    }
    default List<BaseData> getByMapBatch(String system,String scope,String entity,String datasource,List<BaseData> list)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return getByMapBatch(model,scope,dsLink,list);
    }
    default BaseData getDraft(String system,String scope,String entity,String datasource,BaseData et)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return getDraft(model,scope,dsLink,et);
    }
    default boolean checkKey(String system,String scope,String entity,String datasource,BaseData et)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return checkKey(model,scope,dsLink,et);
    }
    default BaseData save(String system,String scope,String entity,String datasource,BaseData et)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return save(model,scope,dsLink,et);
    }
    default List<BaseData> saveBatch(String system,String scope,String entity,String datasource,List<BaseData> list)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return saveBatch(model,scope,dsLink,list);
    }
    default List<BaseData> select(String system,String scope,String entity,String datasource,BaseData et)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return select(model,scope,dsLink,et);
    }
    default Page<BaseData> select(String system,String scope,String entity,String datasource,BaseData et,Pageable pageable)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return select(model,scope,dsLink,et,pageable);
    }
    default List<BaseData> query(String system,String scope,String entity,String datasource,String dataQuery,FilterData context)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return query(model,scope,dsLink,dataQuery,context);
    }
    default Page<BaseData> query(String system,String scope,String entity,String datasource,String dataQuery,FilterData context,Pageable pageable)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return query(model,scope,dsLink,dataQuery,context,pageable);
    }
    default List<BaseData> selectRaw(String system,String scope,String entity,String datasource,String sql,FilterData context)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return selectRaw(model,scope,dsLink,sql,context);
    }
    default boolean execRaw(String system,String scope,String entity,String datasource,String sql,BaseData param)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return execRaw(model,scope,dsLink,sql,param);
    }
    default List<BaseData> fetch(String system,String scope,String entity,String datasource,String dataSet,FilterData context)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return fetch(model,scope,dsLink,dataSet,context);
    }
    default Page<BaseData> fetch(String system,String scope,String entity,String datasource,String dataSet,FilterData context, Pageable pageable)
    {
        DOModel model=getDOModel(system,entity);
        if(StringUtils.isEmpty(datasource))datasource=model.getDefaultDataSource();
        DSLink dsLink=getDSLink(datasource);
        return fetch(model,scope,dsLink,dataSet,context,pageable);
    }


    DOModel getDOModel(String system,String entity);

    DSLink getDSLink(String datasource);

}
