package cn.ibizlab.core.data.mapper;

import cn.ibizlab.core.data.dto.BaseData;
import cn.ibizlab.core.data.dto.FilterData;
import cn.ibizlab.core.data.model.POSchema;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

public interface DbDataMapper   {

    int insertData(@Param("schema") POSchema schema, @Param("data") BaseData data);

    int insertBathData(@Param("schema") POSchema schema, @Param("list") List<BaseData> list);

    int updateData(@Param("schema") POSchema schema, @Param("data") BaseData data);

    int updateBathData(@Param("schema") POSchema schema, @Param("list") List<BaseData> list);

    int removeData(@Param("schema") POSchema schema, @Param("data") BaseData data);

    int removeBathData(@Param("schema") POSchema schema, @Param("list") List<BaseData> list);

    int save(@Param("schema") POSchema schema, @Param("data") BaseData data);

    int saveBatch(@Param("schema") POSchema schema, @Param("list") List<BaseData> list);

    Long countData(@Param("schema") POSchema schema, @Param("data") BaseData data);

    List<BaseData> getData(@Param("schema") POSchema schema, @Param("data") BaseData data);

    List<BaseData> getBatchData(@Param("schema") POSchema schema, @Param("list") List<BaseData> list);

    List<BaseData> getBatchKey(@Param("schema") POSchema schema, @Param("list") List<BaseData> list);

    List<BaseData> selectData(@Param("schema") POSchema schema, @Param("data") BaseData data);

    Page<BaseData> selectData(@Param("schema") POSchema schema, @Param("data") BaseData data, IPage page);

    @Update("${sql}")
    int executeRaw(@Param("schema") POSchema schema, @Param("sql") String sql, @Param("param") BaseData param);

    @Select("${sql}")
    List<BaseData> queryData(@Param("schema") POSchema schema, @Param("sql") String sql, @Param("srf") FilterData context, @Param("ew") QueryWrapper wrapper);
    @Select("${sql}")
    Page<BaseData> queryData(@Param("schema") POSchema schema, @Param("sql") String sql, @Param("srf") FilterData context, @Param("ew") QueryWrapper wrapper, IPage page);





    default int insertData(String ds,@Param("schema") POSchema schema, @Param("data") BaseData data){

        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return insertData(schema,data);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    default int insertBathData(String ds,@Param("schema") POSchema schema, @Param("list") List<BaseData> list){

        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return insertBathData(schema,list); 
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    default int updateData(String ds,@Param("schema") POSchema schema, @Param("data") BaseData data){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return updateData(schema,data);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    default int updateBathData(String ds,@Param("schema") POSchema schema, @Param("list") List<BaseData> list){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return updateBathData(schema,list);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    default int removeData(String ds,@Param("schema") POSchema schema, @Param("data") BaseData data){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return removeData(schema,data);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    default int removeBathData(String ds,@Param("schema") POSchema schema, @Param("list") List<BaseData> list){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return removeBathData(schema,list);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    default int save(String ds,@Param("schema") POSchema schema, @Param("data") BaseData data){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return save(schema,data);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    default int saveBatch(String ds,@Param("schema") POSchema schema, @Param("list") List<BaseData> list){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return saveBatch(schema,list);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    default Long countData(String ds,@Param("schema") POSchema schema, @Param("data") BaseData data){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return countData(schema,data);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    default List<BaseData> getData(String ds,@Param("schema") POSchema schema, @Param("data") BaseData data){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return getData(schema,data);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    default List<BaseData> getBatchData(String ds,@Param("schema") POSchema schema, @Param("list") List<BaseData> list){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return getBatchData(schema,list);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    default List<BaseData> getBatchKey(String ds,@Param("schema") POSchema schema, @Param("list") List<BaseData> list){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return getBatchKey(schema,list);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    default List<BaseData> selectData(String ds,@Param("schema") POSchema schema, @Param("data") BaseData data){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return selectData(schema,data);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    default Page<BaseData> selectData(String ds,@Param("schema") POSchema schema, @Param("data") BaseData data, IPage page){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return selectData(schema,data,page);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    @Update("${sql}")
    default int executeRaw(String ds,@Param("schema") POSchema schema, @Param("sql") String sql, @Param("param") BaseData param){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return executeRaw(schema,sql,param);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

    @Select("${sql}")
    default List<BaseData> queryData(String ds,@Param("schema") POSchema schema, @Param("sql") String sql, @Param("srf") FilterData context, @Param("ew") QueryWrapper wrapper){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return queryData(schema,sql,context,wrapper);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }
    @Select("${sql}")
    default Page<BaseData> queryData(String ds,@Param("schema") POSchema schema, @Param("sql") String sql, @Param("srf") FilterData context, @Param("ew") QueryWrapper wrapper, IPage page){
        try
        {
            DynamicDataSourceContextHolder.push(ds);
            return queryData(schema,sql,context,wrapper,page);
        }
        finally {
            DynamicDataSourceContextHolder.poll();
        }
    }

}