package cn.ibizlab.core.data.lite;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 实体[数据集]
 */
@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@JsonIgnoreProperties(value = "handler")
@ApiModel("数据集")
public class MetaDataSetModel {

    /**
     * 标识
     */
    @JSONField(name = "dataset_id")
    @JsonProperty("dataset_id")
    @ApiModelProperty("标识")
    private String datasetId;
    /**
     * 名称
     */
    @JSONField(name = "dataset_name")
    @JsonProperty("dataset_name")
    @ApiModelProperty("名称")
    private String datasetName;
    /**
     * 实体标识
     */
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    @ApiModelProperty("实体标识")
    private String entityId;
    /**
     * 实体
     */
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    @ApiModelProperty("实体")
    private String entityName;
    /**
     * 代码名称
     */
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    @ApiModelProperty("代码名称")
    private String codeName;
    /**
     * 代码
     */
    @JSONField(name = "ds_code")
    @JsonProperty("ds_code")
    @ApiModelProperty("代码")
    private String dsCode;
    /**
     * 模型
     */
    @JSONField(name = "ds_model")
    @JsonProperty("ds_model")
    @ApiModelProperty("模型")
    private String dsModel;

}


