package cn.ibizlab.core.data.service.impl;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.*;

import cn.ibizlab.core.data.model.POSchema;
import cn.ibizlab.core.data.model.PojoSchema;
import cn.ibizlab.core.data.service.ModelService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import cn.ibizlab.core.data.domain.DOModel;
import cn.ibizlab.core.data.filter.DOModelSearchContext;
import cn.ibizlab.core.data.service.IDOModelService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;


/**
 * 实体[业务实体] 无存储服务对象接口实现
 */
@Slf4j
@Service
public class DOModelServiceImpl implements IDOModelService {

    @Autowired
    private ModelService modelService;

    @Override
    public boolean create(DOModel et) {
        //代码实现
        return true;
    }

    public void createBatch(List<DOModel> list){
    }

    @Override
    public boolean update(DOModel et) {
        //代码实现
        return true;
    }

    public void updateBatch(List<DOModel> list){
    }

    @Override
    public boolean remove(String key) {
        return true;
    }

    public void removeBatch(Collection<String> idList){
    }

    @Cacheable( value="domodel",key = "'row:'+#p0")
    @Override
    public DOModel get(String key) {
        DOModel doModel=null;
        PojoSchema schema= null;
        String[] args=key.split("[.]");
        String system=args[0];
        String entity=args[2];
        Path storePath = Paths.get(ModelService.MODEL_PATH,system,"repo",entity,"domain",entity+".json");
        if(Files.exists(storePath))
        {
            doModel = new DOModel();
            schema = PojoSchema.fromPath(storePath);
            if(schema!=null) {
                doModel.setSchema(schema);
                Path poPath = Paths.get(ModelService.MODEL_PATH, system, "repo", entity, "repository", entity + ".json");
                if (Files.exists(poPath)) {
                    try {
                        doModel.setPoSchemas(JSON.parseObject(new String(Files.readAllBytes(poPath), StandardCharsets.UTF_8), new TypeReference<LinkedHashMap<String, POSchema>>() {
                        }));
                    } catch (IOException e) {

                    }
                }
            }
        }
        Assert.notNull(schema,"未找到对应的模型:"+key);

        return doModel;
    }

    @Override
    public DOModel getDraft(DOModel et) {
        return et;
    }

    @Override
    public boolean checkKey(DOModel et) {
        return false;
    }
    @Override
    @Transactional
    public boolean save(DOModel et) {
        //代码实现
        return true;
    }

    @Override
    public void saveBatch(List<DOModel> list) {
    }





    /**
     * 查询集合 数据集
     */
    @Override
    public Page<DOModel> searchDefault(DOModelSearchContext context) {
        return new PageImpl<DOModel>(new ArrayList(),context.getPageable(),0);
    }

}


