package cn.ibizlab.core.data.service;

import cn.ibizlab.core.data.domain.DOModel;
import cn.ibizlab.core.data.dto.BaseData;
import cn.ibizlab.core.data.dto.FilterData;
import cn.ibizlab.core.data.dto.RequestData;
import cn.ibizlab.core.data.dto.ResponseData;
import cn.ibizlab.core.data.model.DSLink;
import cn.ibizlab.core.data.model.POSchema;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.io.Serializable;
import java.util.List;

public interface IPersistentService {


    BaseData create(DSLink link, POSchema poSchema, BaseData et, boolean bGet);
    List<BaseData> createBatch(DSLink link,POSchema poSchema,List<BaseData> list,boolean bGet);

    BaseData update(DSLink link,POSchema poSchema,BaseData et,boolean bGet);
    List<BaseData> updateBatch(DSLink link,POSchema poSchema,List<BaseData> list,boolean bGet);

    boolean remove(DSLink link,POSchema poSchema,Serializable key);
    boolean removeBatch(DSLink link,POSchema poSchema,List<Serializable> idList);
    boolean removeByMap(DSLink link,POSchema poSchema,BaseData et);
    boolean removeByMapBatch(DSLink link,POSchema poSchema,List<BaseData> list);

    BaseData get(DSLink link,POSchema poSchema,Serializable key);
    List<BaseData> getBatch(DSLink link,POSchema poSchema,List<Serializable> idList);
    BaseData getByMap(DSLink link,POSchema poSchema,BaseData et);
    List<BaseData> getByMapBatch(DSLink link,POSchema poSchema,List<BaseData> list);

    List<BaseData> getBatchKey(DSLink link,POSchema poSchema,List<BaseData> list);

    Long count(DSLink link,POSchema poSchema,BaseData et);
    boolean checkKey(DSLink link,POSchema poSchema,BaseData et);

    BaseData save(DSLink link,POSchema poSchema,BaseData et,boolean bGet);
    List<BaseData> saveBatch(DSLink link,POSchema poSchema,List<BaseData> list,boolean bGet);

    List<BaseData> select(DSLink link,POSchema poSchema,BaseData et);
    Page<BaseData> select(DSLink link,POSchema poSchema,BaseData et,Pageable pageable);

    List<BaseData> query(DSLink link,POSchema poSchema,String dataQuery,FilterData context);
    Page<BaseData> query(DSLink link,POSchema poSchema,String dataQuery,FilterData context,Pageable pageable);

    List<BaseData> selectRaw(DSLink link,POSchema poSchema,String sql,FilterData context);
    boolean execRaw(DSLink link,POSchema poSchema,String sql,BaseData param);

    List<BaseData> fetch(DSLink link,POSchema poSchema,String dataSet,FilterData context);
    Page<BaseData> fetch(DSLink link,POSchema poSchema,String dataSet,FilterData context,Pageable pageable);


 
 
    default BaseData create(String system,String table,String datasource,BaseData et,boolean bGet)
    {
        DSLink link=getDSLink(datasource);
        return create(link,getSchema(link,system,table),et,bGet);
    }
    default  List<BaseData> createBatch(String system,String table,String datasource,List<BaseData> list,boolean bGet)
    {
        DSLink link=getDSLink(datasource);
        return createBatch(link,getSchema(link,system,table),list,bGet);
    }
    default BaseData update(String system,String table,String datasource,BaseData et,boolean bGet)
    {
        DSLink link=getDSLink(datasource);
        return update(link,getSchema(link,system,table),et,bGet);
    }
    default List<BaseData> updateBatch(String system,String table,String datasource,List<BaseData> list,boolean bGet)
    {
        DSLink link=getDSLink(datasource);
        return updateBatch(link,getSchema(link,system,table),list,bGet);
    }
    default boolean remove(String system,String table,String datasource,Serializable key)
    {
        DSLink link=getDSLink(datasource);
        return remove(link,getSchema(link,system,table),key);
    }
    default boolean removeBatch(String system,String table,String datasource,List<Serializable> idList)
    {
        DSLink link=getDSLink(datasource);
        return removeBatch(link,getSchema(link,system,table),idList);
    }
    default boolean removeByMap(String system,String table,String datasource,BaseData et)
    {
        DSLink link=getDSLink(datasource);
        return removeByMap(link,getSchema(link,system,table),et);
    }
    default boolean removeByMapBatch(String system,String table,String datasource,List<BaseData> list)
    {
        DSLink link=getDSLink(datasource);
        return removeByMapBatch(link,getSchema(link,system,table),list);
    }
    default BaseData get(String system,String table,String datasource,Serializable key)
    {
        DSLink link=getDSLink(datasource);
        return get(link,getSchema(link,system,table),key);
    }
    default List<BaseData> getBatch(String system,String table,String datasource,List<Serializable> idList)
    {
        DSLink link=getDSLink(datasource);
        return getBatch(link,getSchema(link,system,table),idList);
    }
    default BaseData getByMap(String system,String table,String datasource,BaseData et)
    {
        DSLink link=getDSLink(datasource);
        return getByMap(link,getSchema(link,system,table),et);
    }
    default List<BaseData> getByMapBatch(String system,String table,String datasource,List<BaseData> list)
    {
        DSLink link=getDSLink(datasource);
        return getByMapBatch(link,getSchema(link,system,table),list);
    }
    default List<BaseData> getBatchKey(String system,String table,String datasource,List<BaseData> list)
    {
        DSLink link=getDSLink(datasource);
        return getBatchKey(link,getSchema(link,system,table),list);
    }
    default Long count(String system,String table,String datasource,BaseData et)
    {
        DSLink link=getDSLink(datasource);
        return count(link,getSchema(link,system,table),et);
    }
    default boolean checkKey(String system,String table,String datasource,BaseData et)
    {
        DSLink link=getDSLink(datasource);
        return checkKey(link,getSchema(link,system,table),et);
    }
    default BaseData save(String system,String table,String datasource,BaseData et,boolean bGet)
    {
        DSLink link=getDSLink(datasource);
        return save(link,getSchema(link,system,table),et,bGet);
    }
    default List<BaseData> saveBatch(String system,String table,String datasource,List<BaseData> list,boolean bGet)
    {
        DSLink link=getDSLink(datasource);
        return saveBatch(link,getSchema(link,system,table),list,bGet);
    }
    default List<BaseData> select(String system,String table,String datasource,BaseData et){
        DSLink link=getDSLink(datasource);
        return select(link,getSchema(link,system,table),et);
    }
    default Page<BaseData> select(String system,String table,String datasource,BaseData et,Pageable pageable){
        DSLink link=getDSLink(datasource);
        return select(link,getSchema(link,system,table),et,pageable);
    }
    default List<BaseData> query(String system,String table,String datasource,String dataQuery,FilterData context){
        DSLink link=getDSLink(datasource);
        return query(link,getSchema(link,system,table),dataQuery,context);
    }
    default Page<BaseData> query(String system,String table,String datasource,String dataQuery,FilterData context,Pageable pageable){
        DSLink link=getDSLink(datasource);
        return query(link,getSchema(link,system,table),dataQuery,context,pageable);
    }
    default List<BaseData> selectRaw(String system,String table,String datasource,String sql,FilterData context){
        DSLink link=getDSLink(datasource);
        return selectRaw(link,getSchema(link,system,table),sql,context);
    }
    default boolean execRaw(String system,String table,String datasource,String sql,BaseData param){
        DSLink link=getDSLink(datasource);
        return execRaw(link,getSchema(link,system,table),sql,param);
    }
    default List<BaseData> fetch(String system,String table,String datasource,String dataSet,FilterData context){
        DSLink link=getDSLink(datasource);
        return fetch(link,getSchema(link,system,table),dataSet,context);
    }
    default Page<BaseData> fetch(String system,String table,String datasource,String dataSet,FilterData context,Pageable pageable){
        DSLink link=getDSLink(datasource);
        return fetch(link,getSchema(link,system,table),dataSet,context,pageable);
    }
    
    DSLink getDSLink(String datasource);

    POSchema getSchema(DSLink link,String system,String table);

}
