package cn.ibizlab.core.data.mongodb;

import com.mongodb.client.MongoDatabase;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;

@Slf4j
public class DynamicMongoTemplate extends MongoTemplate {

  public DynamicMongoTemplate(MongoDbFactory mongoDbFactory) {
    super(mongoDbFactory);
  }

  @Override
  protected MongoDatabase doGetDatabase() {
    MongoDbFactory mongoDbFactory = DynamicMongoContextHolder.getMongoDbFactory();
    return mongoDbFactory == null ? super.doGetDatabase() : mongoDbFactory.getDb();
  }
}
