package cn.ibizlab.core.data.model;

import cn.ibizlab.core.data.dto.DataObj;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown = true)
public class PojoOption extends DataObj
{


    public PojoOption set(String key, Object value)
    {
        this.put(key,value);
        return this;
    }

    public PojoOption setAll(Map map)
    {
        if(map!=null)
            this.putAll(map);
        else if(this.size()==0)
            return null;
        return this;
    }

    public String getName() {
        return this.getStringValue("name",this.getStringValue("code_name"));
    }

    public PojoOption setName(String name) {
        return this.set("name",name);
    }

    public String getSystem(){
        return this.getStringValue("system_id",this.getStringValue("system",this.getStringValue("system_name")));
    }

    public String getSystemName(){
        return this.getStringValue("system_name",this.getStringValue("system",this.getStringValue("system_id")));
    }

    public String getPackage(){
        return this.getStringValue("module_name",this.getStringValue("module",this.getStringValue("moduleid")));
    }


    public String getTableName(){
        return this.getStringValue("table_name",getName());
    }

    public String getEntityName(){
        return this.getStringValue("entity_name","");
    }


    public String getCodeName(){
        return this.getStringValue("code_name","");
    }


    public String getDefaultDataSoruce(){
        return this.getStringValue("ds_name",this.getSystem()+"-master");
    }

    public List<String> getDsTypes(){
        List<String> dsTypes=new ArrayList<>();
        String strDsTypes= this.getStringValue("ds_types");
        for(String dsType:strDsTypes.split(","))
            dsTypes.add(dsType);
        return dsTypes;
    }
    public PojoOption setDsTypes(String dsTypes){
        return this.set("ds_types",dsTypes);
    }

    public String getDefaultQueryScript()
    {
        return this.getStringValue("default_query_script");
    }

    public Boolean isLogicValid() {
        return this.getBooleanValue("logic_valid");
    }

    public PojoOption setLogicValid(Boolean logicValid) {
        return this.set("logic_valid",logicValid);
    }

    public String getLogicVal()
    {
        return this.getStringValue("logicval","1");
    }

    public PojoOption setLogicVal(String logicval) {
        return this.set("logicval",logicval);
    }

    public String getLogicDelVal()
    {
        return this.getStringValue("logicdelval","0");
    }

    public PojoOption setLogicDelVal(String logicdelval) {
        return this.set("logicdelval",logicdelval);
    }

    public String getFieldName() {
        return this.getStringValue("field_name",getName());
    }

    public PojoOption setFieldName(String code) {
        return this.set("field_name",code);
    }


    public String getRelationName() {
        return this.getStringValue("relation_name");
    }

    public PojoOption setRelationName(String relationName) {
        return this.set("relation_name",relationName);
    }


    public String getRelationCodeName() {
        return this.getStringValue("relation_code_name");
    }

    public PojoOption setRelationCodeName(String relationCodeName) {
        return this.set("relation_code_name",relationCodeName);
    }


    public String getRefEntityName() {
        return this.getStringValue("ref_entity_name");
    }

    public PojoOption setRefEntityName(String refEntityName) {
        return this.set("ref_entity_name",refEntityName);
    }

    public String getRefTableName() {
        return this.getStringValue("ref_table_name",getRefEntityName());
    }

    public PojoOption setRefTableName(String refTableName) {
        return this.set("ref_table_name",refTableName);
    }

    public String getRefFieldName() {
        return this.getStringValue("ref_field_name");
    }

    public PojoOption setRefFieldName(String refFieldName) {
        return this.set("ref_field_name",refFieldName);
    }

    public String getRefFieldCodeName() {
        return this.getStringValue("ref_field_code_name");
    }

    public PojoOption setRefFieldCodeName(String refFieldCodeName) {
        return this.set("ref_field_code_name",refFieldCodeName);
    }

    public Boolean isKeyField() {
        return this.getBooleanValue("key_field");
    }

    public PojoOption setKeyField(Boolean keyField) {
        return this.set("key_field",keyField);
    }

    public Boolean isMajorField() {
        return this.getBooleanValue("major_field");
    }

    public PojoOption setMajorField(Boolean majorField) {
        return this.set("major_field",majorField);
    }

    public String getUnionKey() {
        return this.getStringValue("union_key");
    }

    public PojoOption setUnionKey(String unionKey) {
        return this.set("union_key",unionKey);
    }

    public Boolean isPhysicalField() {
        return this.getBooleanValue("physical_field",this.getBooleanValue("Persistent",true));
    }

    public PojoOption setPhysicalField(Boolean physicalField) {
        return this.set("physical_field",physicalField);
    }

    public Boolean isNullable() {
        return this.getBooleanValue("nullable",!this.getBooleanValue("required",true));
    }

    public PojoOption setNullable(Boolean nullable) {
        return this.set("nullable",nullable);
    }

    public String getFieldType() {
        return this.getStringValue("field_type");
    }

    public PojoOption setFieldType(String fieldType) {
        return this.set("field_type",fieldType);
    }

    public String getPredefined() {
        return this.getStringValue("predefined");
    }

    public PojoOption setPredefined(String predefined) {
        return this.set("predefined",predefined);
    }

    public String getDict() {
        return this.getStringValue("dict");
    }

    public PojoOption setDict(String dict) {
        return this.set("dict",dict);
    }
    public String getDefaultValue() {
        return this.getStringValue("default_value");
    }

    public PojoOption setDefaultValue(String defaultValue) {
        return this.set("default_value",defaultValue);
    }
    public String getDataType() {
        return this.getStringValue("data_type");
    }

    public PojoOption setDataType(String dataType) {
        return this.set("data_type",dataType);
    }

    public Integer getDataLength() {
        return this.getIntegerValue("data_length",this.getIntegerValue("length",null));
    }

    public PojoOption setDataLength(Integer dataLength) {
        return this.set("data_length",dataLength);
    }

    public Integer getDataPreci() {
        return this.getIntegerValue("data_preci",this.getIntegerValue("precision",this.getIntegerValue("preci",null)));
    }

    public PojoOption setDataPreci(Integer dataPreci) {
        return this.set("data_preci",dataPreci);
    }

    public String getExpression() {
        return this.getStringValue("expression");
    }

    public PojoOption setExpression(String expression) {
        return this.set("expression",expression);
    }

    public String getSearchModes() {
        return this.getStringValue("search_modes");
    }

    public PojoOption setSearchModes(String search_modes) {
        return this.set("search_modes",search_modes);
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isLogicValidField()
    {
        return "LOGICVALID".equals(this.getPredefined());
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isLastModifyField()
    {
        return "UPDATEDATE".equals(this.getPredefined());
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isCreateTimeField()
    {
        return "CREATEDATE".equals(this.getPredefined());
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isUnionKeyField()
    {
        return !StringUtils.isEmpty(this.getUnionKey());
    }
}
