package cn.ibizlab.core.data.lite;

import cn.ibizlab.core.data.service.ModelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import javax.annotation.PostConstruct;
import java.io.File;

@Component("DataLiteStorage")
public class LiteStorage {

    public static String MODEL_PATH;

    private static LiteModelFeignClient liteModelFeignClient;
    private static DynamicModelService dynamicModelService;
    private static ModelService globalModelService;



    public static void setDynamicModelService(DynamicModelService service)
    {
        if(LiteStorage.dynamicModelService==null)
            LiteStorage.dynamicModelService=service;
    }

    public static DynamicModelService getDynamicModelService()
    {
        return dynamicModelService;
    }

    public static void setLiteModelService(LiteModelFeignClient service)
    {
        if(LiteStorage.liteModelFeignClient==null)
            LiteStorage.liteModelFeignClient=service;
    }

    public static LiteModelFeignClient getLiteModelService()
    {
        return liteModelFeignClient;
    }

    public static void setModelService(ModelService globalModelService)
    {
        if(LiteStorage.globalModelService==null)
            LiteStorage.globalModelService=globalModelService;
    }

    public static ModelService getModelService()
    {
        return globalModelService;
    }


    @Autowired
    private LiteModelFeignClient liteService;

    @Autowired
    @Lazy
    private DynamicModelService dynamicService;

    @Autowired
    private ModelService modelService;



    @PostConstruct
    public void init(){
        LiteStorage.setLiteModelService(liteService);
        LiteStorage.setDynamicModelService(dynamicService);
        LiteStorage.setModelService(modelService);
        LiteStorage.MODEL_PATH=modelService.getModelPath();
    }


}
