package cn.ibizlab.core.data.elasticsearch;

import cn.ibizlab.core.data.mongodb.DynamicMongoContextHolder;
import com.mongodb.client.MongoDatabase;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.data.elasticsearch.client.reactive.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchTemplate;

@Slf4j
public class DynamicEsTemplate extends ReactiveElasticsearchTemplate {
  public DynamicEsTemplate(ReactiveElasticsearchClient client) {
    super(client);
  }


  @Override
  protected ReactiveElasticsearchClient getClient() {
    ReactiveElasticsearchClient client = DynamicEsContextHolder.getReactiveElasticsearchClient();
    return client==null ? super.getClient() : client;
  }

}
