package cn.ibizlab.core.data.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.data.domain.DSSetting;
import cn.ibizlab.core.data.filter.DSSettingSearchContext;


/**
 * 实体[DSSetting] 服务对象接口
 */
public interface IDSSettingService {

    boolean create(DSSetting et);
    void createBatch(List<DSSetting> list);
    boolean update(DSSetting et);
    void updateBatch(List<DSSetting> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    DSSetting get(String key);
    DSSetting getDraft(DSSetting et);
    boolean checkKey(DSSetting et);
    boolean save(DSSetting et);
    void saveBatch(List<DSSetting> list);
    Page<DSSetting> searchDefault(DSSettingSearchContext context);
    DSSetting initDataSource(String tag);
}



