package cn.ibizlab.core.data.domain;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import lombok.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * [持久化对象] 对象
 */
@Builder
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("持久化对象")
public class POModel  implements Serializable {

    /**
     * 标识
     */

    @JSONField(name = "id")
    @JsonProperty("id")
    @ApiModelProperty("标识")
    private String id;

    /**
     * 名称
     */
    @JSONField(name = "name")
    @JsonProperty("name")
    @ApiModelProperty("名称")
    private String name;

    /**
     * 备注
     */
    @JSONField(name = "remarks")
    @JsonProperty("remarks")
    @ApiModelProperty("备注")
    private String remarks;

    /**
     * 系统
     */
    @JSONField(name = "systemId")
    @JsonProperty("systemId")
    @ApiModelProperty("系统")
    private String systemId;

    /**
     * 默认数据源
     */
    @JSONField(name = "dataSource")
    @JsonProperty("dataSource")
    @ApiModelProperty("默认数据源")
    private String dataSource;

    /**
     * 模型
     */
    @JSONField(name = "models")
    @JsonProperty("models")
    @ApiModelProperty("模型")
    private String models;




}


