package cn.ibizlab.core.data.service.impl;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.*;
import java.math.BigInteger;

import cn.ibizlab.core.data.lite.LiteStorage;
import cn.ibizlab.core.data.model.DSLinkConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Value;
import cn.ibizlab.util.errors.BadRequestAlertException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.context.annotation.Lazy;
import cn.ibizlab.core.data.domain.DSSetting;
import cn.ibizlab.core.data.filter.DSSettingSearchContext;
import cn.ibizlab.core.data.service.IDSSettingService;

import org.springframework.util.StringUtils;

import javax.sql.DataSource;


/**
 * 实体[数据源] 无存储服务对象接口实现
 */
@Slf4j
@Service
public class DSSettingServiceImpl implements IDSSettingService {


    @Autowired
    @Lazy
    private DSSettingServiceImpl proxy;

    public Map<String,DSLinkConfig> getAllConfigs()
    {
        Path path = Paths.get(LiteStorage.MODEL_PATH,"DATASOURCE.json");
        try {
            Map<String,DSLinkConfig> all=new HashMap<>();

            if(!Files.exists(path))
            {
                Files.write(path, JSON.toJSONBytes(new LinkedHashMap<String, DSLinkConfig>()), StandardOpenOption.CREATE);
            }
            else
            {
                LinkedHashMap<String,DSLinkConfig> map = JSON.parseObject(new String(Files.readAllBytes(path), StandardCharsets.UTF_8), new TypeReference<LinkedHashMap<String,DSLinkConfig>>(){});

                map.entrySet().forEach(item->{
                    String id=item.getKey();
                    DSLinkConfig config=item.getValue();
                    config.setName(id);
                    if(!all.containsKey(id))
                        all.put(id,config);
                    if(!all.containsKey(id.toLowerCase()))
                        all.put(id.toLowerCase(),config);
                    if(!ObjectUtils.isEmpty(config.getUsings()))
                    {
                        config.getUsings().forEach(using->{
                            if(!all.containsKey(using))
                                all.put(using,config);
                            if(!all.containsKey(using.toLowerCase()))
                                all.put(using.toLowerCase(),config);
                        });
                    }
                });
            }
            return all;
        } catch (Exception e) {
            throw new BadRequestAlertException("读写文件失败","DSLinkConfig",path.toString());
        }

    }

    @Override
    public boolean create(DSSetting et) {
        //代码实现
        return true;
    }

    public void createBatch(List<DSSetting> list){
    }

    @Override
    public boolean update(DSSetting et) {
        //代码实现

        synchronized (lock)
        {
            DynamicRoutingDataSource ds = (DynamicRoutingDataSource) dataSource;
            if (check.containsKey(et.getDsId()))
            {
                if(et.isDatabase())
                    ds.removeDataSource(et.getDsId());
                check.remove(et.getDsId());
            }
            if (!et.getDsId().equals(et.getDsId().toLowerCase()))
            {
                check.remove(et.getDsId().toLowerCase());
            }
            if(!ObjectUtils.isEmpty(et.getUsings()))
            {
                et.getUsings().forEach(using->{
                    check.remove(using);
                    if(!using.equals(using.toLowerCase()))
                        check.remove(using.toLowerCase());
                });
            }

        }
        buildDS(et);
        return true;
    }

    public void updateBatch(List<DSSetting> list){
    }

    @Override
    public boolean remove(String key) {
        return true;
    }

    public void removeBatch(Collection<String> idList){
    }

    @Override
    public DSSetting get(String key) {
        DSSetting et = new DSSetting();

        Map<String,DSLinkConfig> allConfigs=proxy.getAllConfigs();
        if(allConfigs.containsKey(key))
            et.setDSLinkConfig(allConfigs.get(key));
        else
            throw new BadRequestAlertException("未找到数据源配置信息","DSSetting",key);
        return et;
    }

    @Override
    public DSSetting getDraft(DSSetting et) {
        return et;
    }

    @Override
    public boolean checkKey(DSSetting et) {
        return false;
    }
    @Override
    @Transactional
    public boolean save(DSSetting et) {
        //代码实现
        return true;
    }

    @Override
    public void saveBatch(List<DSSetting> list) {
    }


    private HashMap<String,DSSetting> check=new HashMap<>();
    private Object lock=new Object();

    public DSSetting initDataSource(String tag)
    {
        if (check.containsKey(tag))
            return check.get(tag);

        DSSetting dstDataSource=null;
        synchronized (lock)
        {
            if (check.containsKey(tag))
                return check.get(tag);
            dstDataSource=this.get(tag);

            if ((!tag.equalsIgnoreCase(dstDataSource.getDsId()))&&check.containsKey(dstDataSource.getDsId()))
                return check.get(dstDataSource.getDsId());
        }
        return buildDS(dstDataSource);
    }

    public DSSetting buildDS(DSSetting dstDataSource) {
        if(dstDataSource!=null&&(!StringUtils.isEmpty(dstDataSource.getDsCfg())))
        {
            synchronized (lock)
            {
                if(dstDataSource.isDatabase())
                {
                    DataSourceProperty dataSourceProperty = dstDataSource.getDataSourceProperty();
                    DynamicRoutingDataSource ds = dataSource;
                    DataSource dataSource = druidDataSourceCreator.createDataSource(dataSourceProperty);
                    ds.addDataSource(dstDataSource.getDsId(), dataSource);
                }
                check.put(dstDataSource.getDsId(), dstDataSource);
                if(!dstDataSource.getDsId().equals(dstDataSource.getDsId().toLowerCase()))
                    check.put(dstDataSource.getDsId().toLowerCase(), dstDataSource);
                if(!ObjectUtils.isEmpty(dstDataSource.getUsings()))
                {
                    dstDataSource.getUsings().forEach(using->{
                        check.put(using, dstDataSource);
                        if(!using.equals(using.toLowerCase()))
                            check.put(using.toLowerCase(), dstDataSource);
                    });
                }
            }
        }

        return dstDataSource;
    }

    @Autowired
    @Lazy
    private DynamicRoutingDataSource dataSource;

    @Autowired
    @Lazy
    private DataSourceCreator druidDataSourceCreator;


    /**
     * 查询集合 数据集
     */
    @Override
    public Page<DSSetting> searchDefault(DSSettingSearchContext context) {
        return new PageImpl<DSSetting>(new ArrayList(),context.getPageable(),0);
    }

}


