package cn.ibizlab.core.data.mapper;

import cn.ibizlab.core.data.dto.BaseData;
import cn.ibizlab.core.data.dto.FilterData;
import cn.ibizlab.core.data.model.POSchema;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

public interface DbDataMapper   {

    int insertData(@Param("schema") POSchema schema, @Param("data") BaseData data);

    int insertBathData(@Param("schema") POSchema schema, @Param("list") List<BaseData> list);

    int updateData(@Param("schema") POSchema schema, @Param("data") BaseData data);

    int updateBathData(@Param("schema") POSchema schema, @Param("list") List<BaseData> list);

    int removeData(@Param("schema") POSchema schema, @Param("data") BaseData data);

    int removeBathData(@Param("schema") POSchema schema, @Param("list") List<BaseData> list);

    int save(@Param("schema") POSchema schema, @Param("data") BaseData data);

    int saveBatch(@Param("schema") POSchema schema, @Param("list") List<BaseData> list);

    int countData(@Param("schema") POSchema schema, @Param("data") BaseData data);

    List<BaseData> getData(@Param("schema") POSchema schema, @Param("data") BaseData data);

    List<BaseData> getBatchData(@Param("schema") POSchema schema, @Param("list") List<BaseData> list);

    List<BaseData> getBatchKey(@Param("schema") POSchema schema, @Param("list") List<BaseData> list);

    List<BaseData> selectData(@Param("schema") POSchema schema, @Param("data") BaseData data);

    Page<BaseData> selectData(@Param("schema") POSchema schema, @Param("data") BaseData data, IPage page);

    @Update("${sql}")
    boolean executeRaw(@Param("schema") POSchema schema, @Param("sql") String sql, @Param("param") BaseData param);

    @Select("${sql}")
    List<BaseData> queryData(@Param("schema") POSchema schema, @Param("sql") String sql, @Param("srf") FilterData context, @Param("ew") QueryWrapper wrapper);
    @Select("${sql}")
    Page<BaseData> queryData(@Param("schema") POSchema schema, @Param("sql") String sql, @Param("srf") FilterData context, @Param("ew") QueryWrapper wrapper, IPage page);

}