package cn.ibizlab.core.data.rest;

import cn.ibizlab.core.data.dto.BaseData;
import cn.ibizlab.core.data.dto.FilterData;
import cn.ibizlab.core.data.dto.RequestData;
import cn.ibizlab.core.data.dto.ResponseData;
import cn.ibizlab.core.data.service.IDataService;
import cn.ibizlab.util.errors.BadRequestAlertException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@Slf4j
@Api(tags = {"数据" })
@RestController("api-data")
@RequestMapping({"/ibiz-repository/{system}/{scope}","/ibiz-repo/{system}"})
public class DataResource
{
    @Autowired
    public IDataService dataService;

	@ApiOperation(value = "callMethod数据", tags = {"数据" },  notes = "callMethod数据")
	@RequestMapping(method = {RequestMethod.GET}, value = {"/{entity}/call{method}","/{entity}/{key}/call{method}"})
	public ResponseEntity call(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,
			@PathVariable(name = "method",required = true) String method,
			@PathVariable(name = "key",required = false) String key,
							   @RequestParam Map map) {
		RequestData requestData=new RequestData().setAll(map);
		return doCall(system,scope,entity,datasource,method,key,requestData);
	}

	@ApiOperation(value = "callMethod数据", tags = {"数据" },  notes = "callMethod数据")
	@RequestMapping(method = {RequestMethod.POST}, value = {"/{entity}/call{method}","/{entity}/{key}/call{method}"})
	public ResponseEntity doCall(@PathVariable(name = "system",required = true) String system,
							   @PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
							   @RequestParam(name = "datasource",required = false) String datasource,
							   @PathVariable(name = "method",required = true) String method,
							   @PathVariable(name = "key",required = false) String key,@RequestBody(required = false) RequestData requestData) {
		if(requestData==null)
			requestData=new RequestData();
		ResponseData responseData=dataService.call(system,scope,entity,datasource,method,requestData.setKey(key));
		return ResponseEntity.status(HttpStatus.OK).body(responseData.getBody());
	}

	@ApiOperation(value = "批量callMethod数据", tags = {"数据" },  notes = "批量callMethod数据")
	@RequestMapping(method = {RequestMethod.POST}, value = {"/{entity}/call{method}batch"})
	public ResponseEntity callBatch(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,
			@PathVariable(name = "method",required = true) String method,@RequestBody List<RequestData> requestDatas) {
		if(requestDatas!=null)
			requestDatas.forEach(requestData ->dataService.call(system,scope,entity,datasource,method,requestData) );
		return ResponseEntity.status(HttpStatus.OK).body(true);
	}



    @ApiOperation(value = "新建数据", tags = {"数据" },  notes = "新建数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/{entity}","/{entity}/create"})
    public ResponseEntity<BaseData> create(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @Validated @RequestBody BaseData baseData) {
		dataService.create(system,scope,entity,datasource,baseData);
		return ResponseEntity.status(HttpStatus.OK).body(baseData);
    }

    @ApiOperation(value = "批量新建数据", tags = {"数据" },  notes = "批量新建数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/{entity}/batch","/{entity}/createbatch"})
    public ResponseEntity<Boolean> createBatch(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @RequestBody List<BaseData> baseDatas) {
        dataService.createBatch(system,scope,entity,datasource,baseDatas);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "获取数据", tags = {"数据" },  notes = "获取数据")
	@RequestMapping(method = RequestMethod.GET, value = {"/{entity}","/{entity}/{key}"})
    public ResponseEntity<BaseData> get(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,
										@PathVariable(name = "key",required = false) String key,@RequestParam Map map) {
		BaseData baseData=BaseData.fromContext(map);
        return doGet(system,scope,entity,datasource,key,baseData);
    }

	@ApiOperation(value = "获取数据", tags = {"数据" },  notes = "获取数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/{entity}/get","/{entity}/{key}/get"})
	public ResponseEntity<BaseData> doGet(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,
			@PathVariable(name = "key",required = false) String key,@Validated @RequestBody(required = false) BaseData baseData) {
		if(baseData==null)
		{
			if(StringUtils.isEmpty(key))
				throw new BadRequestAlertException("未找到要获取的键值信息",entity,null);
			baseData=new BaseData();
		}
		return ResponseEntity.status(HttpStatus.OK).body(dataService.getByMap(system,scope,entity,datasource,baseData.setKey(key)));
	}

    @ApiOperation(value = "删除数据", tags = {"数据" },  notes = "删除数据")
	@RequestMapping(method = RequestMethod.DELETE, value = {"/{entity}","/{entity}/{key}"})
    public ResponseEntity<Boolean> remove(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,
			@PathVariable(name = "key",required = false) String key,@RequestParam Map map) {
		BaseData baseData=BaseData.fromContext(map);
		return doRemove(system,scope,entity,datasource,key,baseData);
    }

	@ApiOperation(value = "删除数据", tags = {"数据" },  notes = "删除数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/{entity}/remove","/{entity}/{key}/remove"})
	public ResponseEntity<Boolean> doRemove(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,
			@PathVariable(name = "key",required = false) String key,@Validated @RequestBody(required = false) BaseData baseData) {
		if(baseData==null)
		{
			if(StringUtils.isEmpty(key))
				throw new BadRequestAlertException("未找到要删除的键值信息",entity,null);
			baseData=new BaseData();
		}
		return ResponseEntity.status(HttpStatus.OK).body(dataService.removeByMap(system,scope,entity,datasource,baseData.setKey(key)));
	}

    @ApiOperation(value = "批量删除数据", tags = {"数据" },  notes = "批量删除数据")
	@RequestMapping(method = RequestMethod.DELETE, value = {"/{entity}/batch"})
    public ResponseEntity<Boolean> removeBatch(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @RequestBody List ids) {
        return  doRemoveBatch(system,scope,entity,datasource,ids);
    }

	@ApiOperation(value = "批量删除数据", tags = {"数据" },  notes = "批量删除数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/{entity}/removebatch"})
	public ResponseEntity<Boolean> doRemoveBatch(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @RequestBody List ids) {
		dataService.removeBatch(system,scope,entity,datasource,ids);
		return  ResponseEntity.status(HttpStatus.OK).body(true);
	}

    @ApiOperation(value = "更新数据", tags = {"数据" },  notes = "更新数据")
	@RequestMapping(method = RequestMethod.PUT, value = {"/{entity}","/{entity}/{key}"})
    public ResponseEntity<BaseData> update(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,
			@PathVariable(name = "key",required = false) String key, @RequestBody BaseData baseData) {
        return doUpdate(system,scope,entity,datasource,key,baseData);
    }

	@ApiOperation(value = "更新数据", tags = {"数据" },  notes = "更新数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/{entity}/update","/{entity}/{key}/update"})
	public ResponseEntity<BaseData> doUpdate(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,
			@PathVariable(name = "key",required = false) String key, @RequestBody BaseData baseData) {
		dataService.update(system,scope,entity,datasource,baseData.setKey(key));
		return ResponseEntity.status(HttpStatus.OK).body(baseData);
	}

    @ApiOperation(value = "批量更新数据", tags = {"数据" },  notes = "批量更新数据")
	@RequestMapping(method = RequestMethod.PUT, value = {"/{entity}/batch"})
    public ResponseEntity<Boolean> updateBatch(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @RequestBody List<BaseData> baseDatas) {
        return  doUpdateBatch(system,scope,entity,datasource,baseDatas);
    }

	@ApiOperation(value = "批量更新数据", tags = {"数据" },  notes = "批量更新数据")
	@RequestMapping(method = RequestMethod.POST, value = {"/{entity}/updatebatch"})
	public ResponseEntity<Boolean> doUpdateBatch(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource, @RequestBody List<BaseData> baseDatas) {
		dataService.updateBatch(system,scope,entity,datasource,baseDatas);
		return  ResponseEntity.status(HttpStatus.OK).body(true);
	}

    @ApiOperation(value = "检查数据", tags = {"数据" },  notes = "检查数据")
	@RequestMapping(method = {RequestMethod.GET}, value = {"/{entity}/checkkey","/{entity}/{key}/checkkey"})
    public ResponseEntity<Boolean> checkKey(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,
			@PathVariable(name = "key",required = false) String key,
											@RequestParam Map map) {
		BaseData baseData=BaseData.fromContext(map);
        return  doCheckKey(system,scope,entity,datasource,key,baseData);
    }

	@ApiOperation(value = "检查数据", tags = {"数据" },  notes = "检查数据")
	@RequestMapping(method = {RequestMethod.POST}, value = {"/{entity}/checkkey","/{entity}/{key}/checkkey"})
	public ResponseEntity<Boolean> doCheckKey(@PathVariable(name = "system",required = true) String system,
											@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
											@RequestParam(name = "datasource",required = false) String datasource,
											@PathVariable(name = "key",required = false) String key,@RequestBody(required = false) BaseData baseData) {
		if(baseData==null)
		{
			if(StringUtils.isEmpty(key))
				throw new BadRequestAlertException("未找到要检查的键值信息",entity,null);
			baseData=new BaseData();
		}
		return  ResponseEntity.status(HttpStatus.OK).body(dataService.checkKey(system,scope,entity,datasource,baseData.setKey(key)));
	}


	@ApiOperation(value = "获取数据草稿", tags = {"数据" },  notes = "获取数据草稿")
	@RequestMapping(method = {RequestMethod.GET}, value = {"/{entity}/getdraft","/{entity}/{key}/getdraft"})
    public ResponseEntity<BaseData> getDraft(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,
			@PathVariable(name = "key",required = false) String key,
											 @RequestParam Map map) {
		BaseData baseData=BaseData.fromContext(map);
        return doGetDraft(system,scope,entity,datasource,key,baseData);
    }

	@ApiOperation(value = "获取数据草稿", tags = {"数据" },  notes = "获取数据草稿")
	@RequestMapping(method = {RequestMethod.POST}, value = {"/{entity}/getdraft","/{entity}/{key}/getdraft"})
	public ResponseEntity<BaseData> doGetDraft(@PathVariable(name = "system",required = true) String system,
											 @PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
											 @RequestParam(name = "datasource",required = false) String datasource,
											 @PathVariable(name = "key",required = false) String key, @RequestBody(required = false) BaseData baseData) {
		if(baseData==null)baseData=new BaseData();
		return ResponseEntity.status(HttpStatus.OK).body(dataService.getDraft(system,scope,entity,datasource,baseData.setKey(key)));
	}

    @ApiOperation(value = "保存数据", tags = {"数据" },  notes = "保存数据，自动判断插入和更新")
	@RequestMapping(method = RequestMethod.POST, value = {"/{entity}/save","/{entity}/{key}/save"})
    public ResponseEntity<BaseData> save(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,
			@PathVariable(name = "key",required = false) String key, @RequestBody BaseData baseData) {
        dataService.save(system,scope,entity,datasource,baseData.setKey(key));
        return ResponseEntity.status(HttpStatus.OK).body(baseData);
    }

    @ApiOperation(value = "批量保存数据", tags = {"数据" },  notes = "批量保存数据，自动判断插入和更新")
	@RequestMapping(method = RequestMethod.POST, value = {"/{entity}/savebatch"})
    public ResponseEntity<Boolean> saveBatch(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,@RequestBody List<BaseData> baseDatas) {
        dataService.saveBatch(system,scope,entity,datasource,baseDatas);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "获取数据集", tags = {"数据" } ,notes = "获取数据集，GET，返回body<list>+header<page,total>")
    @RequestMapping(method= RequestMethod.GET , value={"/{entity}/fetch{dataset}"})
	public ResponseEntity<List<BaseData>> fetch(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,@PathVariable(name = "dataset",required = true) String dataset,
			@RequestParam Map map) {
		FilterData context=FilterData.fromContext(map);
		return doFetch(system,scope,entity,datasource,dataset,context);
	}

	@ApiOperation(value = "获取数据集", tags = {"数据" } ,notes = "获取数据集，POST，返回body<list>+header<page,total>")
	@RequestMapping(method= RequestMethod.POST , value={"/{entity}/fetch{dataset}","/{entity}/fetch{dataset}"})
	public ResponseEntity<List<BaseData>> doFetch(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,@PathVariable(name = "dataset",required = true) String dataset,
			@RequestBody(required = false) FilterData context) {
		if(context==null)context=new FilterData();
		if(context.needPage()) {
			Page<BaseData> baseDatas = dataService.fetch(system, scope, entity, datasource, dataset, context, context.getPageable());
			List<BaseData> list = baseDatas.getContent();
			return ResponseEntity.status(HttpStatus.OK)
					.header("x-page", String.valueOf(context.getPageable().getPageNumber()))
					.header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
					.header("x-total", String.valueOf(baseDatas.getTotalElements()))
					.body(list);
		}
		else {
			List<BaseData> list = dataService.fetch(system,scope,entity,datasource,dataset,context) ;
			return ResponseEntity.status(HttpStatus.OK)
					.header("x-page", "0")
					.header("x-per-page", String.valueOf(list.size()))
					.header("x-total", String.valueOf(list.size()))
					.body(list);
		}
	}

	@ApiOperation(value = "获取数据集", tags = {"数据" } ,notes = "获取数据集，POST，返回body<page,total,list>")
    @RequestMapping(method= RequestMethod.POST , value={"/{entity}/search{dataset}","/{entity}/search{dataset}"})
	public ResponseEntity<Page<BaseData>> search(@PathVariable(name = "system",required = true) String system,
			@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
			@RequestParam(name = "datasource",required = false) String datasource,@PathVariable(name = "dataset",required = true) String dataset,
			@RequestBody(required = false) FilterData context) {
		if(context==null)context=new FilterData();
		Page<BaseData> baseDatas = dataService.fetch(system,scope,entity,datasource,dataset,context,context.getPageable()) ;
		return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(baseDatas.getContent(), context.getPageable(), baseDatas.getTotalElements()));
	}



	@ApiOperation(value = "查询数据", tags = {"数据" } ,notes = "查询数据，GET，返回body<list>+header<page,total>")
	@RequestMapping(method= RequestMethod.GET , value={"/{entity}/query{dataquery}","/{entity}/query{dataquery}"})
	public ResponseEntity<List<BaseData>> query(@PathVariable(name = "system",required = true) String system,
												@PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
												@RequestParam(name = "datasource",required = false) String datasource,@PathVariable(name = "dataquery",required = true) String dataquery,
												@RequestParam Map map) {
		FilterData context=FilterData.fromContext(map);
		return doQuery(system,scope,entity,datasource,dataquery,context);
	}

	@ApiOperation(value = "查询数据", tags = {"数据" } ,notes = "查询数据，POST，返回body<list>+header<page,total>")
	@RequestMapping(method= RequestMethod.POST , value={"/{entity}/query{dataquery}","/{entity}/query{dataquery}"})
	public ResponseEntity<List<BaseData>> doQuery(@PathVariable(name = "system",required = true) String system,
												 @PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
												 @RequestParam(name = "datasource",required = false) String datasource,@PathVariable(name = "dataquery",required = true) String dataquery,
												 @RequestBody(required = false) FilterData context) {
		if(context==null)context=new FilterData();
		if(context.needPage()) {
			Page<BaseData> baseDatas = dataService.query(system,scope,entity,datasource,dataquery,context,context.getPageable()) ;
			List<BaseData> list = baseDatas.getContent();
			return ResponseEntity.status(HttpStatus.OK)
					.header("x-page", String.valueOf(context.getPageable().getPageNumber()))
					.header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
					.header("x-total", String.valueOf(baseDatas.getTotalElements()))
					.body(list);
		}
		else {
			List<BaseData> list = dataService.query(system,scope,entity,datasource,dataquery,context) ;
			return ResponseEntity.status(HttpStatus.OK)
					.header("x-page", "0")
					.header("x-per-page", String.valueOf(list.size()))
					.header("x-total", String.valueOf(list.size()))
					.body(list);
		}
	}

	@ApiOperation(value = "查询数据", tags = {"数据" } ,notes = "查询数据，POST，返回body<page,total,list>")
	@RequestMapping(method= RequestMethod.POST , value={"/{entity}/page{dataquery}","/{entity}/page{dataquery}"})
	public ResponseEntity<Page<BaseData>> queryPage(@PathVariable(name = "system",required = true) String system,
												 @PathVariable(name = "scope",required = false) String scope,@PathVariable(name = "entity",required = true) String entity,
												 @RequestParam(name = "datasource",required = false) String datasource,@PathVariable(name = "dataquery",required = true) String dataquery,
												 @RequestBody(required = false) FilterData context) {
		if(context==null)context=new FilterData();
		Page<BaseData> baseDatas = dataService.fetch(system,scope,entity,datasource,dataquery,context,context.getPageable()) ;
		return ResponseEntity.status(HttpStatus.OK)
				.body(new PageImpl(baseDatas.getContent(), context.getPageable(), baseDatas.getTotalElements()));
	}


}

