package cn.ibizlab.core.data.dto;

import cn.ibizlab.core.data.domain.DOModel;
import cn.ibizlab.core.data.domain.DTOModel;
import cn.ibizlab.core.data.model.POSchema;
import cn.ibizlab.core.data.model.PojoSchema;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.util.Map;

@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BaseData extends DataObj
{

	public BaseData set(String key, Object value)
	{
		this.put(key,value);
		return this;
	}

	public Serializable getSerializableValue(String key)
	{
		Object obj=this.get(key);
		if(obj!=null)
			return (Serializable)obj;
		else
			return null;
	}

	public BaseData setAll(Map map)
	{
		if(map!=null)
			this.putAll(map);
		else if(this.size()==0)
			return null;
		return this;
	}

	@Override
	public BaseData remove(Object key) {
		super.remove(key);
		return this;
	}

	@JsonIgnore
	@JSONField(serialize = false)
	private POSchema _poschema;
	@JsonIgnore
	@JSONField(serialize = false)
	public POSchema getPOSchema()
	{
		return _poschema;
	}

	public BaseData setPOSchema(POSchema poSchema)
	{
		this._poschema=poSchema;
		return this;
	}


	@JsonIgnore
	@JSONField(serialize = false)
	private DOModel _domodel;
	@JsonIgnore
	@JSONField(serialize = false)
	public DOModel getDOModel()
	{
		return _domodel;
	}

	public BaseData setDOModel(DOModel doModel)
	{
		this._domodel=doModel;
		return this;
	}

	@JsonIgnore
	@JSONField(serialize = false)
	private DTOModel _dtomodel;
	@JsonIgnore
	@JSONField(serialize = false)
	public DTOModel getDTOModel()
	{
		return _dtomodel;
	}

	public BaseData setDTOModel(DTOModel dtoModel)
	{
		this._dtomodel=dtoModel;
		return this;
	}

	@JsonIgnore
	@JSONField(serialize = false)
	private PojoSchema _pojoschema;
	@JsonIgnore
	@JSONField(serialize = false)
	public PojoSchema getPojoSchema()
	{
		if(_pojoschema==null)
		{
			DOModel doModel=this.getDOModel();
			if(doModel!=null)
				_pojoschema=doModel.getSchema();
		}
		if(_pojoschema==null)
		{
			DTOModel dtoModel=this.getDTOModel();
			if(dtoModel!=null)
				_pojoschema=dtoModel.getSchema();
		}
		return _pojoschema;
	}

	public BaseData setKey(Object key)
	{
		return this.set("_key",key);
	}

	public Serializable getKey()
	{
		return getSerializableValue("_key");
	}


	public static BaseData fromContext(Map map)
	{
		if(map==null)
			return null;
		map.remove("datasource");
		if(map.size()==0)
			return null;
		return new BaseData().setAll(map);
	}
}
