package cn.ibizlab.core.data.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;

import cn.ibizlab.core.data.model.PojoSchema;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.util.StringUtils;


/**
 * [数据传输对象] 对象
 */
@Builder
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("数据传输对象")
public class DTOModel  implements Serializable {

    /**
     * 标识
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @ApiModelProperty("标识")
    private String id;

    /**
     * 名称
     */
    @JSONField(name = "name")
    @JsonProperty("name")
    @ApiModelProperty("名称")
    private String name;

    /**
     * 名称
     */
    @JSONField(name = "title")
    @JsonProperty("title")
    @ApiModelProperty("名称")
    private String title;

    /**
     * 系统
     */
    @JSONField(name = "systemId")
    @JsonProperty("systemId")
    @ApiModelProperty("系统")
    private String systemId;

    /**
     * 包名
     */
    @JSONField(name = "packageName")
    @JsonProperty("packageName")
    @ApiModelProperty("包名")
    private String packageName;

    /**
     * 描述
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    @ApiModelProperty("描述")
    private String description;

    /**
     * 定义
     */
    @JSONField(name = "schema")
    @JsonProperty("schema")
    @ApiModelProperty("定义")
    private PojoSchema schema;

    public void setSchema(PojoSchema schema) {

        if(schema!=null)
        {
            if(StringUtils.isEmpty(schema.getId()))
                schema.setId(schema.getSystem()+".dto."+schema.getName());
            this.setId(schema.getId());
            if(!StringUtils.isEmpty(schema.getName()))
                this.setName(schema.getName());
            if(!StringUtils.isEmpty(schema.getSystem()))
                this.setSystemId(schema.getSystem());
            if(!StringUtils.isEmpty(schema.getTitle()))
                this.setTitle(schema.getTitle());
            if(!StringUtils.isEmpty(schema.getDescription()))
                this.setDescription(schema.getDescription());
            if(!StringUtils.isEmpty(schema.getPackage()))
                this.setPackageName(schema.getPackage());
        }
        this.schema = schema;
    }

    /**
     * 模型
     */
    @JSONField(name = "model")
    @JsonProperty("model")
    @ApiModelProperty("模型")
    private String model;

    /**
     * 映射
     */
    @JSONField(name = "mapping")
    @JsonProperty("mapping")
    @ApiModelProperty("映射")
    private String mapping;




}


