package cn.ibizlab.core.data.service;

import cn.ibizlab.core.data.domain.DOModel;
import cn.ibizlab.core.data.dto.BaseData;
import cn.ibizlab.core.data.dto.FilterData;
import cn.ibizlab.core.data.dto.RequestData;
import cn.ibizlab.core.data.dto.ResponseData;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.io.Serializable;
import java.util.List;

public interface IDataService
{

    ResponseData call(DOModel model,String scope,String datasource,String method,RequestData requestData);

    boolean create(DOModel model,String scope,String datasource,BaseData et);
    void createBatch(DOModel model,String scope,String datasource,List<BaseData> list);

    boolean update(DOModel model,String scope,String datasource,BaseData et);
    void updateBatch(DOModel model,String scope,String datasource,List<BaseData> list);

    boolean remove(DOModel model,String scope,String datasource, Serializable key);
    void removeBatch(DOModel model,String scope,String datasource,List<Serializable> idList);
    boolean removeByMap(DOModel model,String scope,String datasource, BaseData et);

    BaseData get(DOModel model,String scope,String datasource,Serializable key);
    List<BaseData> getBatch(DOModel model,String scope,String datasource,List<Serializable> idList);
    BaseData getByMap(DOModel model,String scope,String datasource,BaseData et);

    BaseData getDraft(DOModel model,String scope,String datasource,BaseData et);
    boolean checkKey(DOModel model,String scope,String datasource,BaseData et);

    boolean save(DOModel model,String scope,String datasource,BaseData et);
    void saveBatch(DOModel model,String scope,String datasource,List<BaseData> list);

    List<BaseData> select(DOModel model,String scope,String datasource,BaseData et);
    Page<BaseData> select(DOModel model,String scope,String datasource,BaseData et,Pageable pageable);

    List<BaseData> query(DOModel model,String scope,String datasource,String dataQuery,FilterData context);
    Page<BaseData> query(DOModel model,String scope,String datasource,String dataQuery,FilterData context,Pageable pageable);

    List<BaseData> selectRaw(DOModel model,String scope,String datasource,String sql,FilterData context);
    boolean execRaw(DOModel model,String scope,String datasource,String sql,BaseData param);

    List<BaseData> fetch(DOModel model,String scope,String datasource,String dataSet,FilterData context);
    Page<BaseData> fetch(DOModel model,String scope,String datasource,String dataSet,FilterData context, Pageable pageable);



    default ResponseData call(RequestData requestData)
    {
        return call(requestData.getSystem(),requestData.getScope(),requestData.getEntity(),requestData.getDataSource(),requestData.getMethod(),requestData);
    }

    default ResponseData call(String system,String entity,String method,RequestData requestData)
    {
        return call(system,"",entity,method,"",requestData);
    }

    default boolean create(String system,String entity,BaseData et)
    {
        return create(system,"",entity,"",et);
    }
    default  void createBatch(String system,String entity,List<BaseData> list)
    {
        createBatch(system,"",entity,"",list);
    }
    default boolean update(String system,String entity,BaseData et)
    {
        return update(system,"",entity,"",et);
    }
    default void updateBatch(String system,String entity,List<BaseData> list)
    {
        updateBatch(system,"",entity,"",list);
    }
    default boolean remove(String system,String entity,Serializable key)
    {
        return remove(system,"",entity,"",key);
    }
    default void removeBatch(String system,String entity,List<Serializable> idList)
    {
        removeBatch(system,"",entity,"",idList);
    }
    default boolean removeByMap(String system,String entity,BaseData et)
    {
        return removeByMap(system,"",entity,"",et);
    }
    default BaseData get(String system,String entity,Serializable key)
    {
        return get(system,"",entity,"",key);
    }
    default List<BaseData> getBatch(String system,String entity,List<Serializable> idList)
    {
        return getBatch(system,"",entity,"",idList);
    }
    default BaseData getByMap(String system,String entity,BaseData et)
    {
        return getByMap(system,"",entity,"",et);
    }
    default BaseData getDraft(String system,String entity,BaseData et)
    {
        return getDraft(system,"",entity,"",et);
    }
    default boolean checkKey(String system,String entity,BaseData et)
    {
        return checkKey(system,"",entity,"",et);
    }
    default boolean save(String system,String entity,BaseData et)
    {
        return save(system,"",entity,"",et);
    }
    default void saveBatch(String system,String entity,List<BaseData> list)
    {
        saveBatch(system,"",entity,"",list);
    }
    default List<BaseData> select(String system,String entity,BaseData et){
        return select(system,"",entity,"",et);
    }
    default Page<BaseData> select(String system,String entity,BaseData et,Pageable pageable){
        return select(system,"",entity,"",et,pageable);
    }
    default List<BaseData> query(String system,String entity,String dataQuery,FilterData context){
        return query(system,"",entity,"",dataQuery,context);
    }
    default Page<BaseData> query(String system,String entity,String dataQuery,FilterData context,Pageable pageable){
        return query(system,"",entity,"",dataQuery,context,pageable);
    }
    default List<BaseData> selectRaw(String system,String entity,String sql,FilterData context){
        return selectRaw(system,"",entity,"",sql,context);
    }
    default boolean execRaw(String system,String entity,String sql,BaseData param){
        return execRaw(system,"",entity,"",sql,param);
    }
    default List<BaseData> fetch(String system,String entity, String dataSet,FilterData context)
    {
        return fetch(system,"",entity,"",dataSet,context);
    }
    default Page<BaseData> fetch(String system,String entity, String dataSet,FilterData context,Pageable pageable)
    {
        return fetch(system,"",entity,"",dataSet,context,pageable);
    }

    
    default ResponseData call(String system,String scope,String entity,String datasource,String method,RequestData requestData)
    {
        requestData.setSystem(system).setScope(scope).setEntity(entity).setMethod(method).setDataSource(datasource);
        return call(getDOModel(system,entity),scope,datasource,method,requestData);
    }
    default boolean create(String system,String scope,String entity,String datasource,BaseData et)
    {
        return create(getDOModel(system,entity),scope,datasource,et);
    }
    default  void createBatch(String system,String scope,String entity,String datasource,List<BaseData> list)
    {
        createBatch(getDOModel(system,entity),scope,datasource,list);
    }
    default boolean update(String system,String scope,String entity,String datasource,BaseData et)
    {
        return update(getDOModel(system,entity),scope,datasource,et);
    }
    default void updateBatch(String system,String scope,String entity,String datasource,List<BaseData> list)
    {
        updateBatch(getDOModel(system,entity),scope,datasource,list);
    }
    default boolean remove(String system,String scope,String entity,String datasource,Serializable key)
    {
        return remove(getDOModel(system,entity),scope,datasource,key);
    }
    default void removeBatch(String system,String scope,String entity,String datasource,List<Serializable> idList)
    {
        removeBatch(getDOModel(system,entity),scope,datasource,idList);
    }
    default boolean removeByMap(String system,String scope,String entity,String datasource,BaseData et)
    {
        return removeByMap(getDOModel(system,entity),scope,datasource,et);
    }
    default BaseData get(String system,String scope,String entity,String datasource,Serializable key)
    {
        return get(getDOModel(system,entity),scope,datasource,key);
    }
    default List<BaseData> getBatch(String system,String scope,String entity,String datasource,List<Serializable> idList)
    {
        return getBatch(getDOModel(system,entity),scope,datasource,idList);
    }
    default BaseData getByMap(String system,String scope,String entity,String datasource,BaseData et)
    {
        return getByMap(getDOModel(system,entity),scope,datasource,et);
    }
    default BaseData getDraft(String system,String scope,String entity,String datasource,BaseData et)
    {
        return getDraft(getDOModel(system,entity),scope,datasource,et);
    }
    default boolean checkKey(String system,String scope,String entity,String datasource,BaseData et)
    {
        return checkKey(getDOModel(system,entity),scope,datasource,et);
    }
    default boolean save(String system,String scope,String entity,String datasource,BaseData et)
    {
        return save(getDOModel(system,entity),scope,datasource,et);
    }
    default void saveBatch(String system,String scope,String entity,String datasource,List<BaseData> list)
    {
        saveBatch(getDOModel(system,entity),scope,datasource,list);
    }
    default List<BaseData> select(String system,String scope,String entity,String datasource,BaseData et){
        return select(getDOModel(system,entity),scope,datasource,et);
    }
    default Page<BaseData> select(String system,String scope,String entity,String datasource,BaseData et,Pageable pageable){
        return select(getDOModel(system,entity),scope,datasource,et,pageable);
    }
    default List<BaseData> query(String system,String scope,String entity,String datasource,String dataQuery,FilterData context){
        return query(getDOModel(system,entity),scope,datasource,dataQuery,context);
    }
    default Page<BaseData> query(String system,String scope,String entity,String datasource,String dataQuery,FilterData context,Pageable pageable){
        return query(getDOModel(system,entity),scope,datasource,dataQuery,context,pageable);
    }
    default List<BaseData> selectRaw(String system,String scope,String entity,String datasource,String sql,FilterData context){
        return selectRaw(getDOModel(system,entity),scope,datasource,sql,context);
    }
    default boolean execRaw(String system,String scope,String entity,String datasource,String sql,BaseData param){
        return execRaw(getDOModel(system,entity),scope,datasource,sql,param);
    }
    default List<BaseData> fetch(String system,String scope,String entity,String datasource,String dataSet,FilterData context){
        return fetch(getDOModel(system,entity),scope,datasource,dataSet,context);
    }
    default Page<BaseData> fetch(String system,String scope,String entity,String datasource,String dataSet,FilterData context, Pageable pageable){
        return fetch(getDOModel(system,entity),scope,datasource,dataSet,context,pageable);
    }


    DOModel getDOModel(String system,String entity);

}
