package cn.ibizlab.core.data.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import cn.ibizlab.core.data.domain.DTOModel;
import cn.ibizlab.core.data.filter.DTOModelSearchContext;


/**
 * 实体[DTOModel] 服务对象接口
 */
public interface IDTOModelService {

    boolean create(DTOModel et);
    void createBatch(List<DTOModel> list);
    boolean update(DTOModel et);
    void updateBatch(List<DTOModel> list);
    boolean remove(String key);
    void removeBatch(Collection<String> idList);
    DTOModel get(String key);
    DTOModel getDraft(DTOModel et);
    boolean checkKey(DTOModel et);
    boolean save(DTOModel et);
    void saveBatch(List<DTOModel> list);
    Page<DTOModel> searchDefault(DTOModelSearchContext context);

}



