package cn.ibizlab.core.data.model;

import cn.ibizlab.core.data.domain.POModel;
import cn.ibizlab.core.data.lite.*;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

import java.util.LinkedHashMap;
import java.util.Map;

public class TransUtils {


    public static PojoSchema PojoModel2Schema(PojoModel pojoModel)
    {
        PojoSchema pojoSchema=new PojoSchema().setName(pojoModel.getCode()).setType("object").setTitle(pojoModel.getName()).setId(pojoModel.getId()).setRef(pojoModel.getRef()).setOptions(new PojoOption().setAll(pojoModel.getExtensions()));

        int order=1;
        for(PojoProperty property:pojoModel.getPropertyList()){

            PojoSchema sub=null;
            if(PojoModel.PropertyType.object.equals(property.getPropertyType())) {
                property.setRequired(false);
                if (property.getModel() != null  ) {
                    sub=PojoModel2Schema(property.getModel());
                    sub.setType(PojoSchema.Type.object.getCode()).setName(property.getCode()).setTitle(property.getName()).setPropertyOrder(order).setOptions(new PojoOption().setAll(property.getExtensions()));
                }
            }
            else if(PojoModel.PropertyType.nested.equals(property.getPropertyType())) {
                property.setRequired(false);
                if (property.getModel() != null  ) {
                    sub=new PojoSchema().setType(PojoSchema.Type.array.getCode()).setName(property.getCode()).setTitle(property.getName()).setPropertyOrder(order)
                            .setItems(PojoModel2Schema(property.getModel())).setOptions(new PojoOption().setAll(property.getExtensions()));
                }
            }
            else if(PojoModel.PropertyType.array.equals(property.getPropertyType())) {
                sub=new PojoSchema().setType(PojoSchema.Type.array.getCode()).setName(property.getCode()).setTitle(property.getName()).setPropertyOrder(order)
                        .setItems(new PojoSchema().setType(PojoSchema.Type.string.getCode()).setTitle(property.getName())).setOptions(new PojoOption().setAll(property.getExtensions()));
            }
            else if(PojoModel.PropertyType.integer.equals(property.getPropertyType())) {
                sub=new PojoSchema().setType(PojoSchema.Type.integer.getCode()).setName(property.getCode()).setTitle(property.getName()).setPropertyOrder(order).setOptions(new PojoOption().setAll(property.getExtensions()));
            }
            else if(PojoModel.PropertyType.number.equals(property.getPropertyType())) {
                sub=new PojoSchema().setType(PojoSchema.Type.number.getCode()).setName(property.getCode()).setTitle(property.getName()).setPropertyOrder(order).setOptions(new PojoOption().setAll(property.getExtensions()));
            }
            else if(PojoModel.PropertyType.date.equals(property.getPropertyType())) {
                sub=new PojoSchema().setType(PojoSchema.Type.string.getCode()).setFormat("date").setName(property.getCode()).setTitle(property.getName()).setPropertyOrder(order).setOptions(new PojoOption().setAll(property.getExtensions()));
            }
            else if(PojoModel.PropertyType.datetime.equals(property.getPropertyType())) {
                sub=new PojoSchema().setType(PojoSchema.Type.string.getCode()).setFormat("date-time").setName(property.getCode()).setTitle(property.getName()).setPropertyOrder(order).setOptions(new PojoOption().setAll(property.getExtensions()));
            }
            else{
                sub=new PojoSchema().setType(PojoSchema.Type.string.getCode()).setName(property.getCode()).setTitle(property.getName()).setPropertyOrder(order).setOptions(new PojoOption().setAll(property.getExtensions()));
            }

            if(sub!=null)
            {
                if(property.getRequired())
                    sub.getOptions().setNullable(false);
                if(!StringUtils.isEmpty(property.getDict()))
                    sub.getOptions().setDict(property.getDict());
                if(!StringUtils.isEmpty(property.getDefaultValue()))
                    sub.getOptions().setDefaultValue(property.getDefaultValue());

                pojoSchema.addProperty(sub.getName(),sub);
            }


            order++;

        }

        return pojoSchema;
    }

    public static PojoModel PojoSchema2Model(PojoSchema pojoSchema)
    {
        PojoModel pojoModel=new PojoModel().setCode(pojoSchema.getName()).setName(pojoSchema.getTitle()).setRef(pojoSchema.getRef()).setExtensions(pojoSchema.getOptions());

        for(String name:pojoSchema.getProperties().keySet())
        {
            PojoSchema sub=pojoSchema.getProperties().get(name);
            PojoProperty property=new PojoProperty().setCode(name).setName(sub.getTitle()).setExtensions(new PojoOption().setAll(sub.getOptions()));

            if(PojoSchema.Type.object.getCode().equals(sub.getType()))
            {
                property.setModel(PojoSchema2Model(sub)).setPropertyType(PojoModel.PropertyType.object);
            }
            else if(PojoSchema.Type.array.getCode().equals(sub.getType()))
            {
                PojoSchema subItems=sub.getItems();
                if(subItems!=null&& PojoSchema.Type.object.getCode().equals(subItems.getType()))
                    property.setModel(PojoSchema2Model(subItems)).setPropertyType(PojoModel.PropertyType.nested);
                else
                    property.setPropertyType(PojoModel.PropertyType.array);
            }
            else if(PojoSchema.Type.string.getCode().equals(sub.getType())&&(!StringUtils.isEmpty(sub.getFormat())))
            {
                if("date".equals(sub.getFormat())) property.setPropertyType(PojoModel.PropertyType.date);
                else  if("date-time".equals(sub.getFormat())) property.setPropertyType(PojoModel.PropertyType.datetime);
            }
            else {
                property.setPropertyType(PojoModel.PropertyType.valueOf(sub.getType()));
                if(sub.getOptions()!=null&&(!StringUtils.isEmpty(sub.getOptions().getDict())))
                    property.setDict(sub.getOptions().getDict());
            }

            if(pojoSchema.getRequired()!=null&&pojoSchema.getRequired().contains(name))
                property.setRequired(true);

            pojoModel.addProperty(property);

        }


        return pojoModel;
    }

    public static PojoSchema EntityModelModel2Schema(EntityModel entityModel)
    {
        PojoSchema pojoSchema=new PojoSchema().setName(entityModel.getEntityName()).setType("object").setTitle(entityModel.getLogicName()).setId(entityModel.getEntityId())
                .setOptions(new PojoOption().setDsTypes(String.join(",",entityModel.getDsTypes())).setLogicValid(entityModel.isLogicValid()).setLogicVal(entityModel.getLogicVal()).setLogicDelVal(entityModel.getLogicDelVal()));
        pojoSchema.getOptions().setAll(JSONObject.parseObject(JSON.toJSONString(entityModel.getEntity()))).remove("ext_params");


        int order=1;

        for(FieldModel fieldModel:entityModel.getFields())
        {
            String propType=fieldModel.getPropType();
            PojoSchema sub=null;
            if("date".equals(propType))
                sub=new PojoSchema().setType(PojoSchema.Type.string.getCode()).setFormat("date");
            else if("date-time".equals(propType))
                sub=new PojoSchema().setType(PojoSchema.Type.string.getCode()).setFormat("date-time");
            else
                sub=new PojoSchema().setType(propType);
            sub.setName(fieldModel.getCodeName()).setTitle(fieldModel.getField().getFieldLogicName()).setPropertyOrder(order)
                    .setOptions(new PojoOption().setAll(JSONObject.parseObject(JSON.toJSONString(fieldModel.getField()))));
            sub.getOptions().remove("ext_params");
            if("PICKUP".equals(fieldModel.getField().getFieldType())&&fieldModel.isPhysicalField())
            {
                if(!StringUtils.isEmpty(sub.getOptions().getRelationCodeName()))
                {
                    RelationshipModel relationshipModel=entityModel.getRefMaps().get(sub.getOptions().getRelationCodeName());
                    if(relationshipModel!=null&&(!StringUtils.isEmpty(relationshipModel.getTableName())))
                        sub.getOptions().setRefTableName(relationshipModel.getTableName());
                }

            }
            Object searchModes=fieldModel.getField().get("search_modes");
            if(searchModes!=null)
                sub.getOptions().setSearchModes(searchModes.toString());
            pojoSchema.addProperty(sub.getName(),sub);
            order++;
        }

        if(entityModel.getReferences()!=null)
        {
            for(RelationshipModel rel:entityModel.getReferences())
            {
                PojoSchema sub=new PojoSchema().setType(PojoSchema.Type.object.getCode()).setName(rel.getCodeName()).setTitle(rel.getCodeName()+rel.getEntityLogicName())
                        .setPropertyOrder(order).setOptions(new PojoOption()
                        .set("logic_name",rel.getEntityLogicName())
                                .set("entity_name",rel.getEntityName())
                                .set("system_id",(StringUtils.isEmpty(rel.getSystemId())?entityModel.getSystemId():rel.getSystemId()))
                                .set("entity_id",rel.getEntityId()).set("code_name",rel.getEntityCodeName())
                                .set("table_name",rel.getTableName()).set("ds_name",rel.getDataSourceName()).set("relation",JSONObject.parseObject(JSON.toJSONString(rel.getRelation()), MetaRelationshipModel.class))

                        )
                        .setRef("domain."+rel.getEntityName());
                pojoSchema.addProperty(sub.getName(),sub);
                order++;
            }
        }


        if(entityModel.getNesteds()!=null)
        {
            for(RelationshipModel nest:entityModel.getNesteds())
            {
                PojoSchema sub=new PojoSchema().setType(PojoSchema.Type.array.getCode()).setName(nest.getCodeName()).setTitle(nest.getCodeName()+nest.getEntityLogicName())
                        .setPropertyOrder(order).setOptions(new PojoOption()
                                .set("logic_name",nest.getEntityLogicName())
                                .set("entity_name",nest.getEntityName())
                                .set("system_id",(StringUtils.isEmpty(nest.getSystemId())?entityModel.getSystemId():nest.getSystemId()))
                                .set("entity_id",nest.getEntityId()).set("code_name",nest.getEntityCodeName())
                                .set("table_name",nest.getTableName()).set("ds_name",nest.getDataSourceName()).set("relation",JSONObject.parseObject(JSON.toJSONString(nest.getRelation()), MetaRelationshipModel.class))
                        )
                        .setItems(new PojoSchema().setType(PojoSchema.Type.object.getCode()).setName(nest.getEntityName()).setTitle(nest.getEntityLogicName())
                                .setRef("domain."+nest.getEntityName())
                                .setOptions(new PojoOption()
                                        .set("logic_name",nest.getEntityLogicName())
                                        .set("entity_name",nest.getEntityName())
                                        .set("system_id",(StringUtils.isEmpty(nest.getSystemId())?entityModel.getSystemId():nest.getSystemId()))
                                        .set("entity_id",nest.getEntityId()).set("code_name",nest.getEntityCodeName())
                                        .set("table_name",nest.getTableName()).set("ds_name",nest.getDataSourceName())
                                )
                        );
                pojoSchema.addProperty(sub.getName(),sub);
                order++;
            }
        }




        return pojoSchema;
    }

    public static POSchema PojoSchema2PO(PojoSchema pojoSchema)
    {
        POSchema poSchema=new POSchema().setName(pojoSchema.getDefaultTableName()).setDefaultDataSource(pojoSchema.getDefaultDataSoruce())
                .setRemarks(pojoSchema.getTitle()).setLogicVal(pojoSchema.getOptions().getLogicVal()).setLogicDelVal(pojoSchema.getOptions().getLogicDelVal());



        for(String name:pojoSchema.getProperties().keySet())
        {
            PojoSchema sub=pojoSchema.getProperties().get(name);


            String dataType=sub.getOptions().getDataType();
            Integer length=sub.getOptions().getDataLength();
            Integer precision=sub.getOptions().getDataPreci();

            POSchema.Column column=new POSchema.Column().setName(sub.getOptions().getFieldName()).setAlias(name).setRemarks(sub.getTitle()).setDefaultValue(sub.getOptions().getDefaultValue()).setPredefined(sub.getOptions().getPredefined()).setLength(length);

            if(PojoSchema.Type.object.getCode().equals(sub.getType())||PojoSchema.Type.array.getCode().equals(sub.getType()))
            {
                if(!sub.getOptions().isPhysicalField())
                    continue;

                if(StringUtils.isEmpty(dataType))dataType="TEXT";
                column.setType(dataType);
                column.setLength(null);
            }
            else if(PojoSchema.Type.string.getCode().equals(sub.getType())&&(!StringUtils.isEmpty(sub.getFormat())))
            {
                if(StringUtils.isEmpty(dataType)&&(sub.getFormat().indexOf("date")>=0))
                    dataType="DATETIME";
                else
                    dataType="VARCHAR";
                column.setType(dataType);
            }
            else if(PojoSchema.Type.integer.getCode().equals(sub.getType()) )
            {
                if(StringUtils.isEmpty(dataType))dataType="INT";
                column.setType(dataType);
            }
            else if(PojoSchema.Type.number.getCode().equals(sub.getType()) )
            {
                if(StringUtils.isEmpty(dataType))dataType="NUMBER";
                column.setType(dataType);
            }
            else {
                if(StringUtils.isEmpty(dataType))dataType="VARCHAR";
                column.setType(dataType);
            }

            if(column.isNumber())
                column.setPrecision(precision);

            if((pojoSchema.getRequired()!=null&&pojoSchema.getRequired().contains(name))||(!pojoSchema.getOptions().isNullable()))
                column.getConstraints(true).setNullable(false);

            if(pojoSchema.getKeyMap()!=null&&pojoSchema.getKeyMap().containsKey(column.getName())) {
                String primaryKeyName="PK_"+poSchema.getName().toUpperCase()+"_"+ column.getName().toUpperCase();
                column.getConstraints(true).setPrimaryKey(true).setPrimaryKeyName(primaryKeyName);
            }
            if(sub.getOptions().isLogicValidField())
            {
                if(!StringUtils.isEmpty(pojoSchema.getOptions().getLogicVal()))
                    column.setDefaultValue(pojoSchema.getOptions().getLogicVal());
                else
                    column.setDefaultValue("1");
            }
            if(!StringUtils.isEmpty(sub.getOptions().getSearchModes()))
                column.putSearchModes(sub.getOptions().getSearchModes());

            if("PICKUP".equals(sub.getOptions().getFieldType())&&sub.getOptions().isPhysicalField())
            {
                String fkName=sub.getOptions().getRelationName().toUpperCase();
                if((!StringUtils.isEmpty(sub.getOptions().getRefTableName()))&&(!StringUtils.isEmpty(fkName))) {
                    column.getConstraints(true).setReferencedTableName(sub.getOptions().getRefTableName()).setReferencedColumnNames(sub.getOptions().getRefFieldName()).setForeignKeyName(fkName);

                    poSchema.addForeignKeyConstraint(new POSchema.ForeignKeyConstraint().setConstraintName(fkName).setBaseTableName(poSchema.getName()).setBaseColumnNames(column.getName()).setReferencedTableName(sub.getOptions().getRefTableName()).setReferencedColumnNames(sub.getOptions().getRefFieldName()));
                }
            }

            if(!sub.getOptions().isPhysicalField())
                poSchema.addTransient(column.setComputed(true));
            else
                poSchema.addColumn(column);

        }
        String defaultQueryScript=pojoSchema.getOptions().getDefaultQueryScript();
        if(!StringUtils.isEmpty(defaultQueryScript))
            poSchema.setDefaultQueryScriptSQL(defaultQueryScript);

        return poSchema;
    }


    public static POSchema EntityModelModel2PO(EntityModel entityModel,String dsType) {

        final String dataSourceType=dsType.toLowerCase();
        POSchema poSchema=new POSchema().setDsType(dataSourceType).setName(entityModel.getTableName(dataSourceType)).setDefaultDataSource(entityModel.getDsName())
                .setRemarks(entityModel.getLogicName()).setLogicVal(entityModel.getLogicVal()).setLogicDelVal(entityModel.getLogicDelVal());


        Map<String,FieldModel> keyMap=new LinkedHashMap<>();
        Map<String,RelationshipModel> relationshipModelMap = new LinkedHashMap<>();
        if(entityModel.getKeyFields()!=null)entityModel.getKeyFields().forEach(model->keyMap.put(model.getColumnName(),model));
        if(entityModel.getReferences()!=null)entityModel.getReferences().forEach(model->relationshipModelMap.put(model.getRelation().getName(),model));

        int order = 1;
        for (FieldModel fieldModel : entityModel.getFields()) {
            MetaFieldModel sub=fieldModel.getField();

            String colName=fieldModel.getColumnName(dataSourceType);

            Integer length=sub.getDataLength();
            Integer precision=sub.getDataPreci();

            POSchema.Column column=new POSchema.Column().setName(colName).setAlias(sub.getCodeName()).setRemarks(sub.getFieldLogicName()).setPredefined(sub.getPredefined()).setLength(length).setType(sub.getDataType());

            if(column.isNumber())
                column.setPrecision(precision);

            if(sub.getNullable()!=null&&sub.getNullable()==0)
                column.getConstraints(true).setNullable(false);

            if(keyMap.containsKey(column.getName())) {
                String primaryKeyName="PK_"+poSchema.getName().toUpperCase()+"_"+ column.getName().toUpperCase();
                column.getConstraints(true).setPrimaryKey(true).setPrimaryKeyName(primaryKeyName);
            }
            if(fieldModel.isLogicValidField())
            {
                if(!StringUtils.isEmpty(entityModel.getLogicVal()))
                    column.setDefaultValue(entityModel.getLogicVal());
                else
                    column.setDefaultValue("1");
            }

            Object searchModes=fieldModel.getField().get("search_modes");
            if(searchModes!=null)
                column.putSearchModes(searchModes.toString());

            if("PICKUP".equals(sub.getFieldType())&&fieldModel.isPhysicalField())
            {
                RelationshipModel relationshipModel=relationshipModelMap.get(sub.getRelationName());
                String fkName=sub.getRelationName().toUpperCase();
                if(relationshipModel!=null&&(!StringUtils.isEmpty(relationshipModel.getTableName()))&&(!StringUtils.isEmpty(fkName))) {
                    column.getConstraints(true).setReferencedTableName(relationshipModel.getTableName())
                            .setReferencedColumnNames(sub.getRefFieldName()).setForeignKeyName(fkName);

                    poSchema.addForeignKeyConstraint(new POSchema.ForeignKeyConstraint().setConstraintName(fkName)
                            .setBaseTableName(poSchema.getName()).setBaseColumnNames(column.getName())
                            .setReferencedTableName(relationshipModel.getTableName()).setReferencedColumnNames(sub.getRefFieldName()));
                }
            }
            else  if((!StringUtils.isEmpty(sub.getRelationName()))) {
                RelationshipModel relationshipModel = relationshipModelMap.get(sub.getRelationName());
                String fkName=sub.getRelationName().toUpperCase();
                if(relationshipModel!=null&&(!StringUtils.isEmpty(relationshipModel.getTableName()))&&(!StringUtils.isEmpty(fkName))) {
                    column.getConstraints(true).setReferencedTableName(relationshipModel.getTableName())
                            .setReferencedColumnNames(sub.getRefFieldName());
                }
            }

            if(!fieldModel.isPhysicalField())
                poSchema.addTransient(column.setComputed(true));
            else
                poSchema.addColumn(column);

            order++;
        }

        if(entityModel.getDataSets()!=null)
        {

            entityModel.getDataSets().forEach(dataSet->{

                if(dataSet.getDatasetId().startsWith(entityModel.getEntityName().toLowerCase()+"-")&&dataSet.getDatasetId().endsWith(dataSourceType))
                {
                    POSchema.Segment segment=new POSchema.Segment().setName(dataSet.getDatasetId()).setVendorProvider(dataSourceType).setBody(dataSet.getDsCode());
                    if(!StringUtils.isEmpty(dataSet.getDsModel()))
                        segment.setFormat(dataSet.getDsModel());
                    poSchema.addSegment(segment);
                }
                else  if(!dataSet.getDatasetId().startsWith(entityModel.getEntityName().toLowerCase()+"-"))
                {
                    POSchema.Segment segment=new POSchema.Segment().setName(dataSet.getCodeName()).setVendorProvider(dataSourceType).setBody(dataSet.getDsCode());
                    if(!StringUtils.isEmpty(dataSet.getDsModel()))
                        segment.setFormat(dataSet.getDsModel());
                    poSchema.addSegment(segment);
                }
            });

        }


        return poSchema;
    }

    public static void main(String[] args) {
        String str="{\"code\":\"CaseInfo\",\"name\":\"案件基本信息\",\"group\":\"0预处理/2.预处理接口\",\"propertyList\":[{\"code\":\"send_id\",\"name\":\"请求ID标识\",\"required\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"req_type\",\"name\":\"业务请求类型\",\"required\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"ajbh\",\"name\":\"公共案件编号\",\"required\":true,\"uniqueKeys\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"ajmc\",\"name\":\"公共案件名称\",\"required\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"ab\",\"name\":\"案由代码\",\"required\":false,\"uniqueKeys\":false,\"dict\":\"案由\",\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"gajgysrdh\",\"name\":\"移送人电话\",\"required\":false,\"uniqueKeys\":false,\"dict\":\"\",\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"case_status\",\"name\":\"案件状态\",\"required\":true,\"dict\":\"案件类型\",\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"CaseSuspect_List\",\"name\":\"嫌疑人自然人信息列表\",\"required\":false,\"defaultValue\":\"\",\"propertyType\":\"nested\",\"model\":{\"code\":\"CaseSuspect\",\"name\":\"嫌疑人自然人信息\",\"group\":\"0预处理/2.预处理接口\",\"propertyList\":[{\"code\":\"rybh\",\"name\":\"人员编号\",\"required\":true,\"uniqueKeys\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"rybs\",\"name\":\"公安人员标识\",\"required\":true,\"uniqueKeys\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"xm\",\"name\":\"姓名\",\"required\":true,\"uniqueKeys\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"SuspectCoercive_List\",\"name\":\"嫌疑人强制措施信息列表\",\"required\":false,\"defaultValue\":\"\",\"propertyType\":\"nested\",\"model\":{\"code\":\"SuspectCoercive\",\"name\":\"嫌疑人强制措施信息\",\"group\":\"0预处理/2.预处理接口\",\"propertyList\":[{\"code\":\"gabs\",\"name\":\"公安唯一标识\",\"required\":true,\"uniqueKeys\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"cslb\",\"name\":\"强制措施种类代码\",\"required\":false,\"uniqueKeys\":true,\"dict\":\"强制措施种类\",\"defaultValue\":\"\",\"propertyType\":\"string\"}],\"extensions\":{}}}],\"extensions\":{}}},{\"code\":\"SuspectCompany_List\",\"name\":\"涉案单位信息列表\",\"required\":false,\"defaultValue\":\"\",\"propertyType\":\"nested\",\"model\":{\"code\":\"SuspectCompany\",\"name\":\"涉案人单位信息\",\"group\":\"0预处理/2.预处理接口\",\"propertyList\":[{\"code\":\"gabs\",\"name\":\"公安唯一标识\",\"required\":true,\"uniqueKeys\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"dwmc\",\"name\":\"单位名称\",\"required\":false,\"uniqueKeys\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"}],\"extensions\":{}}},{\"code\":\"CaseSHR_List\",\"name\":\"受害人列表\",\"required\":false,\"defaultValue\":\"\",\"propertyType\":\"nested\",\"model\":{\"code\":\"CaseSHR\",\"name\":\"受害人基本信息\",\"group\":\"0预处理/2.预处理接口\",\"propertyList\":[{\"code\":\"xm\",\"name\":\"姓名\",\"required\":false,\"uniqueKeys\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"}],\"extensions\":{}}},{\"code\":\"CaseSAWP_List\",\"name\":\"涉案物品列表\",\"required\":false,\"defaultValue\":\"\",\"propertyType\":\"nested\",\"model\":{\"code\":\"CaseSAWP\",\"name\":\"涉案物品信息\",\"group\":\"0预处理/2.预处理接口\",\"propertyList\":[{\"code\":\"sawpmc\",\"name\":\"名称\",\"required\":false,\"uniqueKeys\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"}],\"extensions\":{}}},{\"code\":\"CaseStatus_List\",\"name\":\"案件移送记录列表\",\"required\":false,\"defaultValue\":\"\",\"propertyType\":\"object\",\"model\":{\"code\":\"CaseStatus\",\"name\":\"提请逮捕移送记录\",\"group\":\"0预处理/2.预处理接口\",\"propertyList\":[{\"code\":\"send_dept\",\"name\":\"发送部门代码\",\"required\":true,\"dict\":\"单位\",\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"send_deptname\",\"name\":\"发送部门名称\",\"required\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"receive_dept\",\"name\":\"接收部门代码\",\"required\":true,\"dict\":\"单位\",\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"receive_deptname\",\"name\":\"接收部门名称\",\"required\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"send_time\",\"name\":\"发送时间\",\"required\":false,\"defaultValue\":\"\",\"propertyType\":\"date\"},{\"code\":\"send_type\",\"name\":\"移送状态\",\"required\":true,\"uniqueKeys\":true,\"dict\":\"案件类型\",\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"send_type_zh\",\"name\":\"移送状态名称\",\"required\":true,\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"wh_zh\",\"name\":\"文书名称\",\"required\":false,\"defaultValue\":\"\",\"propertyType\":\"string\"},{\"code\":\"wh\",\"name\":\"移送文书文号\",\"required\":false,\"defaultValue\":\"\",\"propertyType\":\"string\"}],\"extensions\":{}}}]}";
        PojoModel pojoModel= JSON.parseObject(str,PojoModel.class);
        PojoSchema schema=PojoModel2Schema(pojoModel);

        System.out.println(JSON.toJSONString(schema));

        String str1="{\"type\":\"object\",\"title\":\"案件基本信息\",\"options\":{\"name\":\"CaseInfo\"},\"properties\":{\"send_id\":{\"type\":\"string\",\"title\":\"请求ID标识\",\"propertyOrder\":1,\"options\":{\"nullable\":false,\"name\":\"send_id\"}},\"req_type\":{\"type\":\"string\",\"title\":\"业务请求类型\",\"propertyOrder\":2,\"options\":{\"nullable\":false,\"name\":\"req_type\"}},\"ajbh\":{\"type\":\"string\",\"title\":\"公共案件编号\",\"propertyOrder\":3,\"options\":{\"nullable\":false,\"name\":\"ajbh\"}},\"ajmc\":{\"type\":\"string\",\"title\":\"公共案件名称\",\"propertyOrder\":4,\"options\":{\"nullable\":false,\"name\":\"ajmc\"}},\"ab\":{\"type\":\"string\",\"title\":\"案由代码\",\"propertyOrder\":5,\"options\":{\"name\":\"ab\",\"dict\":\"案由\"}},\"gajgysrdh\":{\"type\":\"string\",\"title\":\"移送人电话\",\"propertyOrder\":6,\"options\":{\"name\":\"gajgysrdh\"}},\"case_status\":{\"type\":\"string\",\"title\":\"案件状态\",\"propertyOrder\":7,\"options\":{\"nullable\":false,\"name\":\"case_status\",\"dict\":\"案件类型\"}},\"CaseSuspect_List\":{\"type\":\"array\",\"title\":\"嫌疑人自然人信息列表\",\"propertyOrder\":8,\"options\":{\"name\":\"CaseSuspect_List\"},\"items\":{\"type\":\"object\",\"title\":\"嫌疑人自然人信息\",\"options\":{\"name\":\"CaseSuspect\"},\"properties\":{\"rybh\":{\"type\":\"string\",\"title\":\"人员编号\",\"propertyOrder\":1,\"options\":{\"nullable\":false,\"name\":\"rybh\"}},\"rybs\":{\"type\":\"string\",\"title\":\"公安人员标识\",\"propertyOrder\":2,\"options\":{\"nullable\":false,\"name\":\"rybs\"}},\"xm\":{\"type\":\"string\",\"title\":\"姓名\",\"propertyOrder\":3,\"options\":{\"nullable\":false,\"name\":\"xm\"}},\"SuspectCoercive_List\":{\"type\":\"array\",\"title\":\"嫌疑人强制措施信息列表\",\"propertyOrder\":4,\"options\":{\"name\":\"SuspectCoercive_List\"},\"items\":{\"type\":\"object\",\"title\":\"嫌疑人强制措施信息\",\"options\":{\"name\":\"SuspectCoercive\"},\"properties\":{\"gabs\":{\"type\":\"string\",\"title\":\"公安唯一标识\",\"propertyOrder\":1,\"options\":{\"nullable\":false,\"name\":\"gabs\"}},\"cslb\":{\"type\":\"string\",\"title\":\"强制措施种类代码\",\"propertyOrder\":2,\"options\":{\"name\":\"cslb\",\"dict\":\"强制措施种类\"}}},\"required\":[\"gabs\"]}}},\"required\":[\"rybh\",\"rybs\",\"xm\"]}},\"SuspectCompany_List\":{\"type\":\"array\",\"title\":\"涉案单位信息列表\",\"propertyOrder\":9,\"options\":{\"name\":\"SuspectCompany_List\"},\"items\":{\"type\":\"object\",\"title\":\"涉案人单位信息\",\"options\":{\"name\":\"SuspectCompany\"},\"properties\":{\"gabs\":{\"type\":\"string\",\"title\":\"公安唯一标识\",\"propertyOrder\":1,\"options\":{\"nullable\":false,\"name\":\"gabs\"}},\"dwmc\":{\"type\":\"string\",\"title\":\"单位名称\",\"propertyOrder\":2,\"options\":{\"name\":\"dwmc\"}}},\"required\":[\"gabs\"]}},\"CaseSHR_List\":{\"type\":\"array\",\"title\":\"受害人列表\",\"propertyOrder\":10,\"options\":{\"name\":\"CaseSHR_List\"},\"items\":{\"type\":\"object\",\"title\":\"受害人基本信息\",\"options\":{\"name\":\"CaseSHR\"},\"properties\":{\"xm\":{\"type\":\"string\",\"title\":\"姓名\",\"propertyOrder\":1,\"options\":{\"name\":\"xm\"}}},\"required\":[]}},\"CaseSAWP_List\":{\"type\":\"array\",\"title\":\"涉案物品列表\",\"propertyOrder\":11,\"options\":{\"name\":\"CaseSAWP_List\"},\"items\":{\"type\":\"object\",\"title\":\"涉案物品信息\",\"options\":{\"name\":\"CaseSAWP\"},\"properties\":{\"sawpmc\":{\"type\":\"string\",\"title\":\"名称\",\"propertyOrder\":1,\"options\":{\"name\":\"sawpmc\"}}},\"required\":[]}},\"CaseStatus_List\":{\"type\":\"object\",\"title\":\"案件移送记录列表\",\"propertyOrder\":12,\"options\":{\"name\":\"CaseStatus_List\"},\"properties\":{\"send_dept\":{\"type\":\"string\",\"title\":\"发送部门代码\",\"propertyOrder\":1,\"options\":{\"nullable\":false,\"name\":\"send_dept\",\"dict\":\"单位\"}},\"send_deptname\":{\"type\":\"string\",\"title\":\"发送部门名称\",\"propertyOrder\":2,\"options\":{\"nullable\":false,\"name\":\"send_deptname\"}},\"receive_dept\":{\"type\":\"string\",\"title\":\"接收部门代码\",\"propertyOrder\":3,\"options\":{\"nullable\":false,\"name\":\"receive_dept\",\"dict\":\"单位\"}},\"receive_deptname\":{\"type\":\"string\",\"title\":\"接收部门名称\",\"propertyOrder\":4,\"options\":{\"nullable\":false,\"name\":\"receive_deptname\"}},\"send_time\":{\"type\":\"string\",\"title\":\"发送时间\",\"propertyOrder\":5,\"options\":{\"name\":\"send_time\"},\"format\":\"date\"},\"send_type\":{\"type\":\"string\",\"title\":\"移送状态\",\"propertyOrder\":6,\"options\":{\"nullable\":false,\"name\":\"send_type\",\"dict\":\"案件类型\"}},\"send_type_zh\":{\"type\":\"string\",\"title\":\"移送状态名称\",\"propertyOrder\":7,\"options\":{\"nullable\":false,\"name\":\"send_type_zh\"}},\"wh_zh\":{\"type\":\"string\",\"title\":\"文书名称\",\"propertyOrder\":8,\"options\":{\"name\":\"wh_zh\"}},\"wh\":{\"type\":\"string\",\"title\":\"移送文书文号\",\"propertyOrder\":9,\"options\":{\"name\":\"wh\"}}},\"required\":[\"send_dept\",\"send_deptname\",\"receive_dept\",\"receive_deptname\",\"send_type\",\"send_type_zh\"]}},\"required\":[\"send_id\",\"req_type\",\"ajbh\",\"ajmc\",\"case_status\"]}";

        PojoModel model=PojoSchema2Model(schema);
        System.out.println(JSON.toJSONString(model));
    }

}
