package cn.ibizlab.core.data.lite;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

/**
 * 实体[实体关系]
 */
@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@JsonIgnoreProperties(value = "handler")
@ApiModel("实体关系")
public class MetaRelationshipModel implements Serializable {

    /**
     * 关系标识
     */
    @JSONField(name = "id")
    @JsonProperty("id")
    @ApiModelProperty("关系标识")
    private String id;
    /**
     * 关系名称
     */
    @JSONField(name = "name")
    @JsonProperty("name")
    @ApiModelProperty("关系名称")
    private String name;
    /**
     * 类型
     */
    @JSONField(name = "relation_type")
    @JsonProperty("relation_type")
    @ApiModelProperty("类型")
    private String relationType;
    /**
     * 代码名称
     */
    @JSONField(name = "code_name")
    @JsonProperty("code_name")
    @ApiModelProperty("代码名称")
    private String codeName;
    /**
     * 实体标识
     */
    @JSONField(name = "entity_id")
    @JsonProperty("entity_id")
    @ApiModelProperty("实体标识")
    private String entityId;
    /**
     * 实体名称
     */
    @JSONField(name = "entity_name")
    @JsonProperty("entity_name")
    @ApiModelProperty("实体名称")
    private String entityName;
    /**
     * 引用实体标识
     */
    @JSONField(name = "ref_entity_id")
    @JsonProperty("ref_entity_id")
    @ApiModelProperty("引用实体标识")
    private String refEntityId;
    /**
     * 引用实体名称
     */
    @JSONField(name = "ref_entity_name")
    @JsonProperty("ref_entity_name")
    @ApiModelProperty("引用实体名称")
    private String refEntityName;
    /**
     * 嵌套代码名称
     */
    @JSONField(name = "nested_name")
    @JsonProperty("nested_name")
    @ApiModelProperty("嵌套代码名称")
    private String nestedName;
    /**
     * 系统
     */
    @JSONField(name = "system_id")
    @JsonProperty("system_id")
    @ApiModelProperty("系统")
    private String systemId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("创建时间")
    private Timestamp createdate;
    /**
     * 最后修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate", format = "yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("最后修改时间")
    private Timestamp updatedate;




    /**
     * lookup
     */
    @JSONField(name = "lookups")
    @JsonProperty("lookups")
    private List<MetaLookupModel> lookup;

    public MetaRelationshipModel addLookup(MetaLookupModel obj)
    {
        if(lookup==null)
            lookup=new ArrayList<>();
        lookup.add(obj);
        return this;
    }

}


