package cn.ibizlab.core.data.lite;

import cn.ibizlab.util.helper.DataObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.util.StringUtils;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
@JsonIgnoreProperties(value = "handler")
public class FieldModel {

    private String columnName;

    private String codeName;

    private String unionName;

    private String showName;

    private String comment;

    private MetaFieldModel field;

    private RelationshipModel reference;

    @JsonIgnore
    @JSONField(serialize = false)
    public String getColumnExp()
    {
        if(field.getPhysicalField()!=null && 1==field.getPhysicalField())
        {
            return columnName+" as \""+columnName.toUpperCase()+"\"";
        }
        else if(!StringUtils.isEmpty(field.getExpression()))
        {
            return field.getExpression()+" as \""+columnName.toUpperCase()+"\"";
        }
        return "";
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isPhysicalField()
    {
        return this.getField().getPhysicalField()!=null && 1==this.getField().getPhysicalField();
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isKeyField()
    {
        return this.getField().getKeyField()!=null && 1==this.getField().getKeyField();
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isLogicValidField()
    {
        return "LOGICVALID".equals(this.getField().getPredefined());
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isLastModifyField()
    {
        return "UPDATEDATE".equals(this.getField().getPredefined());
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isCreateTimeField()
    {
        return "CREATEDATE".equals(this.getField().getPredefined());
    }

    @JsonIgnore
    @JSONField(serialize = false)
    public boolean isUnionKeyField()
    {
        return !StringUtils.isEmpty(this.getField().getUnionKey());
    }

    public String getPropType()
    {
        String dataType=this.getField().getDataType().toUpperCase();
        if( dataType.indexOf("TEXT")>=0||dataType.indexOf("CHAR")>=0||dataType.indexOf("LOB")>=0)
            return "string";
        else if(dataType.indexOf("TIME")>=0)
            return "date-time";
        else if(dataType.indexOf("DATE")>=0)
            return "date";
        else if(dataType.indexOf("NUM")>=0||dataType.indexOf("FLOAT")>=0||dataType.indexOf("DOUBLE")>=0||dataType.indexOf("DECIMAL")>=0)
            return "number";
        else if(dataType.indexOf("INT")==0)
            return "integer";
        return "string";
    }

    public String getColumnName(String dsType)
    {
        return DataObject.getStringValue(field.get("column-"+dsType.toLowerCase()),getColumnName());
    }

}
