package cn.ibizlab.codegen.templating.mustache;

import cn.ibizlab.codegen.CodegenConfig;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;

/**
 * Converts text in a fragment to lowercase.
 *
 * Register:
 * <pre>
 * additionalProperties.put("lowercase", new LowercaseLambda());
 * </pre>
 *
 * Use:
 * <pre>
 * {{#lowercase}}{{httpMethod}}{{/lowercase}}
 * </pre>
 */
public class LowercaseLambda implements Mustache.Lambda {
    private CodegenConfig generator = null;

    public LowercaseLambda() {

    }

    public LowercaseLambda generator(final CodegenConfig generator) {
        this.generator = generator;
        return this;
    }

    @Override
    public void execute(Template.Fragment fragment, Writer writer) throws IOException {
        String text = fragment.execute().toLowerCase(Locale.ROOT);

        writer.write(text);

    }
}
