package cn.ibizlab.codegen.cmd;

import io.airlift.airline.Command;
import io.airlift.airline.Option;

@SuppressWarnings({"unused", "java:S106"})
@Command(name = "version", description = "Show version information used in tooling")
public class Version extends IbizLabGeneratorCommand {

    @Option(name = {"--sha"}, description = "Git commit SHA version")
    private Boolean sha;

    @Option(name = {"--full"}, description = "Full version details")
    private Boolean full;

    @Override
    public void execute() {
        String version;

        if (Boolean.TRUE.equals(full)) {
            version = buildInfo.versionDisplayText();
        } else if (Boolean.TRUE.equals(sha)) {
            version = buildInfo.getSha();
        } else {
            version = buildInfo.getVersion();
        }
        System.out.println(version);
    }

}
