package cn.ibizlab.codegen.templating;


public enum TemplateFileType {
    ctrl(Constants.CTRLS),
    page(Constants.PAGES),
    appEntity(Constants.APP_ENTITIES),
    apiEntity(Constants.API_ENTITIES),
    entity(Constants.ENTITIES),
    module(Constants.MODULES),
    api(Constants.APIS),
    app(Constants.APPS),
    supportingFiles(Constants.SUPPORTING_FILES);

    private final String templateType;

    TemplateFileType(String templateType) { this.templateType = templateType; }

    /**
     * Returns the value for this template file type
     *
     * @return The template type of this enum.
     */
    public String value() { return this.templateType; }



    /**
     * Obtains the {@link TemplateFileType} for an input string.
     *
     * @param templateType a {@link String} object.
     * @return a {@link TemplateFileType} object.
     */
    public static TemplateFileType forTemplateType(String templateType) {
        for (TemplateFileType value : values()) {
            if (value.templateType.equals(templateType)) {
                return value;
            }
        }
        throw new IllegalArgumentException("templateType not found in the available values.");
    }

    public static class Constants {
        public static final String APIS = "apis";
        public static final String APPS = "apps";
        public static final String ENTITIES = "entities";
        public static final String API_ENTITIES = "apiEntities";
        public static final String APP_ENTITIES = "appEntities";
        public static final String MODULES = "modules";
        public static final String PAGES = "pages";
        public static final String CTRLS = "ctrls";
        public static final String SUPPORTING_FILES = "supportingFiles";
    }
}
