package cn.ibizlab.codegen.model;

import cn.ibizlab.codegen.templating.TemplateFileType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import cn.ibizlab.codegen.CodegenConstants;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown = true)
public class CliOption extends DataObj
{

    private TemplateFileType templateFileType;

    public CliOption setTemplateFileType(TemplateFileType templateFileType)
    {
        this.templateFileType=templateFileType;
        return this;
    }

    public TemplateFileType getTemplateFileType()
    {
        return this.templateFileType;
    }

    private String cliSubType;

    public CliOption setCliSubType(String cliSubType)
    {
        this.cliSubType=cliSubType;
        return this;
    }

    public String getCliSubType()
    {
        return this.cliSubType;
    }

    public CliOption baseData(Object baseData,String path)
    {
        Assert.notNull(templateFileType,"模板类型为空");
        this.set(templateFileType.name(),baseData);
        this.set(templateFileType.value(),path);
        if(!StringUtils.isEmpty(this.cliSubType))
            this.set(templateFileType.value()+"@"+this.cliSubType,path);
        return this;
    }

    public CliOption set(String key, Object value)
    {
        this.put(key,value);
        return this;
    }

    public CliOption setAll(Map map)
    {
        if(map!=null)
            this.putAll(map);
        else if(this.size()==0)
            return null;
        return this;
    }

    public String getProjectName(){
        return this.getStringValue(CodegenConstants.PROJECT_NAME,"");
    }

    public CliOption setProjectName(String projectName)
    {
        return this.set(CodegenConstants.PROJECT_NAME,projectName);
    }

    public String getProjectDesc(){
        return this.getStringValue(CodegenConstants.PROJECT_DESC,getProjectName());
    }

    public CliOption setProjectDesc(String projectDesc)
    {
        return this.set(CodegenConstants.PROJECT_DESC,projectDesc);
    }

    public String getPackageName(){
        return this.getStringValue(CodegenConstants.PACKAGE_NAME,"cn.ibizlab");
    }

    public CliOption setPackageName(String packageName)
    {
        return this.set(CodegenConstants.PACKAGE_NAME,packageName);
    }

    public String getModule(){
        return this.getStringValue("module",this.getStringValue("module_id",this.getStringValue("module_name",this.getStringValue("modules"))));
    }

    public CliOption setModule(String module)
    {
        this.set("modules",module);
        return this.set("module",module);
    }


    public String getCodeName(){
        return this.getStringValue("code_name","");
    }


    @Override
    public int size() {
        return super.size();
    }

    public int getSize()
    {
        return super.size();
    }
}
