package cn.ibizlab.codegen.model;


import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.control.IPSControl;
import net.ibizsys.model.control.layout.IPSGridLayoutPos;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class CtrlModel extends BaseModel{

    public CtrlModel(AppModel appModel,IPSControl psControl)
    {
        this.opt=psControl;
        this.app=appModel;
        this.setCodeName(psControl.getCodeName());
        this.setName(psControl.getName());

        if(psControl.getPSAppDataEntity()!=null)
            folder=new LabelExt(psControl.getPSAppDataEntity().getCodeName());
        else
            folder=new LabelExt("app");

        this.setId(String.format("%1$s-%2$s-%3$s",app.getCodeName(),folder,psControl.getCodeName()));

    }

    private AppModel app;

    private AppEntityModel appEntity;

    private LabelExt folder;

    public IPSControl getControl()
    {
        return (IPSControl)opt;
    }

    public void getGridOptions(IPSGridLayoutPos layoutPos)
    {
        System.out.println(layoutPos);
    }
}
