package cn.ibizlab.codegen.model;

import org.springframework.util.StringUtils;

public class BaseModel implements IModel {

    protected String id;

    protected String codeName;

    protected String name;

    public String getId() {
        if(StringUtils.isEmpty(id)&&(!StringUtils.isEmpty(getCodeName())))
            id=this.getCodeName();
        return id;
    }


    public <T> T setId(String id) {
        this.id = id;
        return (T)this;
    }

    public String getCodeName() {
        return codeName;
    }




    public <T> T setCodeName(String codeName) {
        this.codeName = codeName;
        return (T)this;
    }

    public String getName() {
        return name;
    }

    public <T> T setName(String name) {
        this.name = name;
        return (T)this;
    }

    protected Object opt;

    public  <T> T setOpt(Object opt)
    {
        this.opt=opt;
        return (T)this;
    }

    protected DataObj extParams=new DataObj();

    public <T> T set(String key,Object val)
    {
        extParams.set(key,val);
        return (T)this;
    }

    public Object get(String key)
    {
        return extParams.get(key);
    }

    public Object getOpt() {
        return opt;
    }

    public DataObj getExtParams() {
        return extParams;
    }

    public <T> T setExtParams(DataObj extParams) {
        this.extParams = extParams;
        return (T)this;
    }


}
