package cn.ibizlab.codegen.model;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.app.view.IPSAppView;
import org.springframework.util.StringUtils;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class PageModel extends BaseModel{

    public PageModel(AppModel appModel,IPSAppView appView)
    {
        this.opt=appView;
        this.app=appModel;
        this.setCodeName(appView.getCodeName());
        this.setName(appView.getName());
        this.setId(String.format("%1$s-%2$s",app.getCodeName(),appView.getCodeName()));

        if(appView.getPSAppDataEntity()!=null)
            this.appEntity=app.getAppEntity(appView.getPSAppDataEntity().getCodeName());

        if(appView.getPSControls()!=null)
        {
            appView.getPSControls().forEach(item->{
                CtrlModel ctrl=new CtrlModel(appModel,item);
                if(!this.app.getCtrlsMap().containsKey(ctrl.getId()))
                {
                    if(ctrl.getControl().getPSAppDataEntity()!=null) {
                        AppEntityModel ctrlAppEntity=app.getAppEntity(ctrl.getControl().getPSAppDataEntity().getCodeName());
                        ctrl.setAppEntity(ctrlAppEntity);
                        ctrlAppEntity.addCtrl(ctrl.getCodeName().toString(),ctrl);
                    }
                    this.app.getCtrlsMap().put(ctrl.getId(),ctrl);
                    this.ctrlsMap.put(ctrl.getCodeName().toString(),ctrl);
                }
            });
        }

    }

    public IPSAppView getAppView()
    {
        return (IPSAppView)opt;
    }

    private AppModel app;

    private AppEntityModel appEntity;

    public LabelExt getAppModule()
    {
        String appModules="default";
        if(getAppView().getPSAppDataEntity()!=null)
            appModules=getAppView().getPSAppDataEntity().getCodeName();

        return new LabelExt(appModules);
    }

    private Map<String,CtrlModel> ctrlsMap=new LinkedHashMap<>();

    public Collection<CtrlModel> getCtrls(){
        return ctrlsMap.values();
    }


}
