package cn.ibizlab.codegen.model;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.app.dataentity.IPSAppDataEntity;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class AppEntityModel extends BaseModel{

    public AppEntityModel(AppModel appModel,IPSAppDataEntity appDataEntity)
    {
        this.opt=appDataEntity;
        this.app=appModel;
        this.setCodeName(appDataEntity.getCodeName());
        this.setName(appDataEntity.getName());
        this.setId(String.format("%1$s-%2$s",app.getCodeName(),appDataEntity.getCodeName()));

    }

    public IPSAppDataEntity getAppDataEntity()
    {
        return (IPSAppDataEntity)opt;
    }

    private AppModel app;

    public Map<String,CtrlModel> ctrlsMap=new LinkedHashMap();

    public AppEntityModel addCtrl(String codeName,CtrlModel ctrlModel)
    {
        if(!ctrlsMap.containsKey(codeName))
            ctrlsMap.put(codeName,ctrlModel);
        return this;
    }

    public Collection<CtrlModel> getCtrls()
    {
        return ctrlsMap.values();
    }

}
