package cn.ibizlab.codegen.model;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.ibizsys.model.service.IPSSysServiceAPI;

import java.util.*;

@Getter
@Setter
@NoArgsConstructor
@Accessors(chain = true)
public class ApiModel extends BaseModel{

    public ApiModel(IPSSysServiceAPI api)
    {
        this.opt=api;
        this.setCodeName(api.getCodeName());
        this.setName(api.getName());
        if(getSysServiceApi().getPSDEServiceAPIs()!=null)
        {
            getSysServiceApi().getPSDEServiceAPIs().forEach(item->{
                apiEntitiesMap.put(item.getCodeName(),new ApiEntityModel(this, item));
            });
        }
    }


    private SystemModel system;

    public IPSSysServiceAPI getSysServiceApi()
    {
        return (IPSSysServiceAPI)opt;
    }


    private Map<String,ApiEntityModel> apiEntitiesMap=new LinkedHashMap<>();

    public Collection<ApiEntityModel> getApiEntities() {
        return apiEntitiesMap.values();
    }

    public ApiEntityModel getApiEntity(String codeName)
    {
        return apiEntitiesMap.get(codeName);
    }
}
